signature partitionTheory =
sig
  type thm = Thm.thm
  
  (*  Definitions  *)
    val part_def : thm
    val partition_def : thm
  
  (*  Theorems  *)
    val part_MEM : thm
    val part_length : thm
    val part_length_lem : thm
    val parts_have_prop : thm
  
  val partition_grammars : parse_type.grammar * term_grammar.grammar
(*
   [list] Parent theory of "partition"
   
   [option] Parent theory of "partition"
   
   [part_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (!P l1 l2. part P [] l1 l2 = (l1,l2)) /\
      !P h rst l1 l2.
        part P (h::rst) l1 l2 =
        (if P h then part P rst (h::l1) l2 else part P rst l1 (h::l2))
   
   [partition_def]
   Definition
   [oracles: ] [axioms: ] [] |- !P l. partition P l = part P l [] []
   
   [part_MEM]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P L a1 a2 l1 l2.
        ((a1,a2) = part P L l1 l2) ==>
        !x. MEM x (APPEND L (APPEND l1 l2)) = MEM x (APPEND a1 a2)
   
   [part_length]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P L l1 l2 p q.
        ((p,q) = part P L l1 l2) ==>
        (LENGTH L + LENGTH l1 + LENGTH l2 = LENGTH p + LENGTH q)
   
   [part_length_lem]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P L l1 l2 p q.
        ((p,q) = part P L l1 l2) ==>
        LENGTH p <= LENGTH L + LENGTH l1 + LENGTH l2 /\
        LENGTH q <= LENGTH L + LENGTH l1 + LENGTH l2
   
   [parts_have_prop]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P L A B l1 l2.
        ((A,B) = part P L l1 l2) /\ (!x. MEM x l1 ==> P x) /\
        (!x. MEM x l2 ==> ~P x) ==>
        (!z. MEM z A ==> P z) /\ !z. MEM z B ==> ~P z
   
   
*)
end
