(* ---------------------------------------------------------------------*)
(* CONTENTS: functions which are common to paired universal and		*)
(*		existential quantifications.				*)
(* ---------------------------------------------------------------------*)
(*$Id: Pair_both1.sml,v 1.2 2000/11/16 12:50:22 kxs Exp $*)

structure Pair_both1 :> Pair_both1 =
struct

open HolKernel Parse boolLib Pair_syn Pair_basic Abbrev;

infixr -->;
infix |->;

val PAIR_ERR = mk_HOL_ERR "pair library";
    

fun mk_fun(y1,y2) = y1 --> y2;
fun comma(ty1,ty2) = Term.inst [alpha |-> ty1, beta |-> ty2] pairSyntax.comma;

val PFORALL_THM = pairTheory.PFORALL_THM;
val PEXISTS_THM = pairTheory.PEXISTS_THM;

val mk_pforall      = pairSyntax.mk_forall;
val dest_pforall    = pairSyntax.dest_forall;
val list_mk_pforall = pairSyntax.list_mk_forall;

(* ------------------------------------------------------------------------- *)
(* CURRY_FORALL_CONV "!(x,y).t" = (|- (!(x,y).t) = (!x y.t))                 *)
(* ------------------------------------------------------------------------- *)

    
fun CURRY_FORALL_CONV tm = 
    let val (xy,bod) = dest_pforall tm
	val (x,y) = pairSyntax.dest_pair xy
	val result = list_mk_pforall ([x,y],bod) 
	val f = rand (rand tm)
	val th1 = RAND_CONV (PABS_CONV (UNPBETA_CONV xy)) tm 
	val th2 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV CURRY_CONV))) th1 
	val th3 = (SYM (ISPEC f PFORALL_THM)) 
	val th4 = CONV_RULE (RATOR_CONV (RAND_CONV (GEN_PALPHA_CONV xy))) th3 
	val th5 = CONV_RULE (RAND_CONV (GEN_PALPHA_CONV x)) (TRANS th2 th4) 
	val th6 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV
						   (GEN_PALPHA_CONV y)))) th5 
	val th7 = CONV_RULE(RAND_CONV(RAND_CONV(PABS_CONV (RAND_CONV 
                                (PABS_CONV(RATOR_CONV PBETA_CONV)))))) th6
	val th8 =
	    CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV (RAND_CONV 
                         (PABS_CONV PBETA_CONV))))) th7
    in
        TRANS th8 (REFL result)
    end    
    handle HOL_ERR _ => failwith "CURRY_FORALL_CONV" ;

(* ------------------------------------------------------------------------- *)
(* CURRY_EXISTS_CONV "?(x,y).t" = (|- (?(x,y).t) = (?x y.t))                 *)
(* ------------------------------------------------------------------------- *)

fun CURRY_EXISTS_CONV tm = 
    let val (xy,bod) = dest_pexists tm 
	val (x,y) = pairSyntax.dest_pair xy 
	val result = list_mk_pexists ([x,y],bod) 
	val f = rand (rand tm) 
	val th1 = RAND_CONV (PABS_CONV (UNPBETA_CONV xy)) tm 
	val th2 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV CURRY_CONV))) th1 
	val th3 = (SYM (ISPEC f PEXISTS_THM)) 
	val th4 = CONV_RULE (RATOR_CONV (RAND_CONV (GEN_PALPHA_CONV xy))) th3 
	val th5 = CONV_RULE (RAND_CONV (GEN_PALPHA_CONV x)) (TRANS th2 th4) 
	val th6 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV
						   (GEN_PALPHA_CONV y)))) th5 
	val th7 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV (RAND_CONV 
                       (PABS_CONV (RATOR_CONV PBETA_CONV)))))) th6 
	val th8 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV 
                               (RAND_CONV (PABS_CONV PBETA_CONV))))) th7
    in 
	TRANS th8 (REFL result)
    end
handle HOL_ERR _ => failwith "CURRY_EXISTS_CONV" ;

(* ------------------------------------------------------------------------- *)
(* UNCURRY_FORALL_CONV "!x y.t" = (|- (!x y.t) = (!(x,y).t))                 *)
(* ------------------------------------------------------------------------- *)

fun UNCURRY_FORALL_CONV tm =
    let val (x,Body) = dest_pforall tm
	val (y,bod) = dest_pforall Body
	val xy = pairSyntax.mk_pair(x,y)
	val result = mk_pforall (xy,bod)
	val th1 = (RAND_CONV (PABS_CONV (RAND_CONV (PABS_CONV
						    (UNPBETA_CONV xy))))) tm 
	val f = rand (rator (pbody (rand (pbody (rand (rand (concl th1)))))))
	val th2 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV 
                              (RAND_CONV (PABS_CONV CURRY_CONV))))) th1 
	val th3 = ISPEC f PFORALL_THM 
	val th4 = CONV_RULE (RATOR_CONV (RAND_CONV (GEN_PALPHA_CONV x))) th3 
	val th5 = CONV_RULE (RATOR_CONV (RAND_CONV (RAND_CONV (PABS_CONV
		(GEN_PALPHA_CONV y))))) th4 
	val th6 = CONV_RULE (RAND_CONV (GEN_PALPHA_CONV xy)) (TRANS th2 th5) 
	val th7 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV (RATOR_CONV
			    PBETA_CONV)))) th6 
	val th8 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV PBETA_CONV))) th7
    in
	TRANS th8 (REFL result)
    end
handle HOL_ERR _ => failwith "UNCURRY_FORALL_CONV";

(* ------------------------------------------------------------------------- *)
(* UNCURRY_EXISTS_CONV "?x y.t" = (|- (?x y.t) = (?(x,y).t))                 *)
(* ------------------------------------------------------------------------- *)

fun UNCURRY_EXISTS_CONV tm =
    let val (x,Body) = dest_pexists tm
	val (y,bod) = dest_pexists Body
	val xy = pairSyntax.mk_pair{fst=x,snd=y}
	val result = mk_pexists (xy,bod)
	val th1 = (RAND_CONV (PABS_CONV (RAND_CONV (PABS_CONV
						    (UNPBETA_CONV xy))))) tm 
	val f = rand (rator (pbody (rand (pbody (rand (rand (concl th1))))))) 
	val th2 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV 
                              (RAND_CONV (PABS_CONV CURRY_CONV))))) th1 
	val th3 = ISPEC f PEXISTS_THM 
	val th4 = CONV_RULE (RATOR_CONV (RAND_CONV (GEN_PALPHA_CONV x))) th3 
	val th5 = CONV_RULE (RATOR_CONV (RAND_CONV (RAND_CONV (PABS_CONV
			       (GEN_PALPHA_CONV y))))) th4 
	val th6 = CONV_RULE (RAND_CONV (GEN_PALPHA_CONV xy)) (TRANS th2 th5) 
	val th7 = CONV_RULE (RAND_CONV (RAND_CONV 
                        (PABS_CONV (RATOR_CONV PBETA_CONV)))) th6 
	val th8 = CONV_RULE (RAND_CONV (RAND_CONV (PABS_CONV PBETA_CONV))) th7
    in
	TRANS th8 (REFL result)
    end
    handle HOL_ERR _ => failwith "UNCURRY_EXISTS_CONV";

end;
