signature milTheory =
sig
  type thm = Thm.thm
  
  (*  Definitions  *)
    val ARROW_DEF : thm
    val G : thm
    val IN : thm
    val THM : thm
    val ii_internalmil0_def : thm
    val ii_internalmil1_def : thm
    val ty_TY_DEF : thm
    val ty_case_def : thm
    val ty_repfns : thm
    val ty_size_def : thm
  
  (*  Theorems  *)
    val CURRY_HOWARD : thm
    val ty_11 : thm
    val ty_Axiom : thm
    val ty_case_cong : thm
    val ty_distinct : thm
    val ty_induction : thm
    val ty_nchotomy : thm
  
  val mil_grammars : parse_type.grammar * term_grammar.grammar
(*
   [cl] Parent theory of "mil"
   
   [ARROW_DEF]
   Definition
   [oracles: ] [axioms: ] [] |- $-> = ii_internalmil1
   
   [G]  Definition  [oracles: ] [axioms: ] [] |- G = ii_internalmil0
   
   [IN]
   Definition
   [oracles: ] [axioms: ] []
   |- $IN =
      (\a0 a1.
         !IN'.
           (!a0 a1.
              (?A B. (a0 = K) /\ (a1 = A -> B -> A)) \/
              (?A B C.
                 (a0 = S) /\ (a1 = (A -> B -> C) -> (A -> B) -> A -> C)) \/
              (?M N. (a0 = M # N) /\ ?t1. IN' M (t1 -> a1) /\ IN' N t1) ==>
              IN' a0 a1) ==>
           IN' a0 a1)
   
   [THM]
   Definition
   [oracles: ] [axioms: ] []
   |- THM =
      (\a0.
         !THM'.
           (!a0.
              (?A B. a0 = A -> B -> A) \/
              (?A B C. a0 = (A -> B -> C) -> (A -> B) -> A -> C) \/
              (?P. THM' (P -> a0) /\ THM' P) ==>
              THM' a0) ==>
           THM' a0)
   
   [ii_internalmil0_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalmil0 =
      (\a. ii_internal_mk_ty ((\a. CONSTR 0 a (\n. BOTTOM)) a))
   
   [ii_internalmil1_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalmil1 =
      (\a0 a1.
         ii_internal_mk_ty
           ((\a0 a1.
               CONSTR (SUC 0) (@v. T) (FCONS a0 (FCONS a1 (\n. BOTTOM))))
              (ii_internal_dest_ty a0) (ii_internal_dest_ty a1)))
   
   [ty_TY_DEF]
   Definition
   [oracles: ] [axioms: ] []
   |- ?rep.
        TYPE_DEFINITION
          (\a0'.
             !'ty'.
               (!a0'.
                  (?a. a0' = (\a. CONSTR 0 a (\n. BOTTOM)) a) \/
                  (?a0 a1.
                     (a0' =
                      (\a0 a1.
                         CONSTR (SUC 0) (@v. T)
                           (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                     'ty' a0 /\ 'ty' a1) ==>
                  'ty' a0') ==>
               'ty' a0') rep
   
   [ty_case_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (!f f1 a. ty_case f f1 (G a) = f a) /\
      !f f1 a0 a1. ty_case f f1 (a0 -> a1) = f1 a0 a1
   
   [ty_repfns]
   Definition
   [oracles: ] [axioms: ] []
   |- (!a. ii_internal_mk_ty (ii_internal_dest_ty a) = a) /\
      !r.
        (\a0'.
           !'ty'.
             (!a0'.
                (?a. a0' = (\a. CONSTR 0 a (\n. BOTTOM)) a) \/
                (?a0 a1.
                   (a0' =
                    (\a0 a1.
                       CONSTR (SUC 0) (@v. T)
                         (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                   'ty' a0 /\ 'ty' a1) ==>
                'ty' a0') ==>
             'ty' a0') r =
        (ii_internal_dest_ty (ii_internal_mk_ty r) = r)
   
   [ty_size_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (!f a. ty_size f (G a) = 1 + f a) /\
      !f a0 a1. ty_size f (a0 -> a1) = 1 + (ty_size f a0 + ty_size f a1)
   
   [CURRY_HOWARD]
   Theorem
   [oracles: ] [axioms: ] [] |- !P. THM P = ?M. M IN P
   
   [ty_11]
   Theorem
   [oracles: ] [axioms: ] []
   |- (!a a'. (G a = G a') = (a = a')) /\
      !a0 a1 a0' a1'. (a0 -> a1 = a0' -> a1') = (a0 = a0') /\ (a1 = a1')
   
   [ty_Axiom]
   Theorem
   [oracles: ] [axioms: ] []
   |- !f0 f1.
        ?fn.
          (!a. fn (G a) = f0 a) /\
          !a0 a1. fn (a0 -> a1) = f1 a0 a1 (fn a0) (fn a1)
   
   [ty_case_cong]
   Theorem
   [oracles: ] [axioms: ] []
   |- !f1' f1 f' f M' M.
        (M = M') /\ (!a. (M' = G a) ==> (f a = f' a)) /\
        (!a0 a1. (M' = a0 -> a1) ==> (f1 a0 a1 = f1' a0 a1)) ==>
        (ty_case f f1 M = ty_case f' f1' M')
   
   [ty_distinct]
   Theorem
   [oracles: ] [axioms: ] [] |- !a1 a0 a. ~(G a = a0 -> a1)
   
   [ty_induction]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P. (!a. P (G a)) /\ (!t t0. P t /\ P t0 ==> P (t -> t0)) ==> !t. P t
   
   [ty_nchotomy]
   Theorem
   [oracles: ] [axioms: ] [] |- !t. (?a. t = G a) \/ ?t' t0. t = t' -> t0
   
   
*)
end
