signature clTheory =
sig
  type thm = Thm.thm
  
  (*  Definitions  *)
    val ---> : thm
    val ===> : thm
    val CR : thm
    val HASH_DEF : thm
    val IDEF : thm
    val K : thm
    val RTC : thm
    val S : thm
    val TC : thm
    val cl_TY_DEF : thm
    val cl_case_def : thm
    val cl_repfns : thm
    val cl_size_def : thm
    val ii_internalcl0_def : thm
    val ii_internalcl1_def : thm
    val ii_internalcl2_def : thm
    val preduce : thm
    val reduce : thm
  
  (*  Theorems  *)
    val CHURCH_ROSSER : thm
    val CR_LEMMA : thm
    val NOT_C_CR : thm
    val RED_EQ_PRED : thm
    val TC_PRESERVES_CR : thm
    val cl_11 : thm
    val cl_Axiom : thm
    val cl_case_cong : thm
    val cl_distinct : thm
    val cl_induction : thm
    val cl_nchotomy : thm
    val preduce_HAS_CR : thm
  
  val cl_grammars : parse_type.grammar * term_grammar.grammar
(*
   [ind_type] Parent theory of "cl"
   
   [pair] Parent theory of "cl"
   
   [sum] Parent theory of "cl"
   
   [--->]
   Definition
   [oracles: ] [axioms: ] []
   |- $---> =
      (\a0 a1.
         !--->'.
           (!a0 a1.
              (?y. a0 = K # a1 # y) \/
              (?x y z. (a0 = S # x # y # z) /\ (a1 = x # z # (y # z))) \/
              (?x y z. (a0 = x # z) /\ (a1 = y # z) /\ --->' x y) \/
              (?x y z. (a0 = z # x) /\ (a1 = z # y) /\ --->' x y) ==>
              --->' a0 a1) ==>
           --->' a0 a1)
   
   [===>]
   Definition
   [oracles: ] [axioms: ] []
   |- $===> =
      (\a0 a1.
         !===>'.
           (!a0 a1.
              (a1 = a0) \/ (?y. a0 = K # a1 # y) \/
              (?x y z. (a0 = S # x # y # z) /\ (a1 = x # z # (y # z))) \/
              (?w x y z.
                 (a0 = w # y) /\ (a1 = x # z) /\ ===>' w x /\
                 ===>' y z) ==>
              ===>' a0 a1) ==>
           ===>' a0 a1)
   
   [CR]
   Definition
   [oracles: ] [axioms: ] []
   |- !R. CR R = !a b. R a b ==> !c. R a c ==> ?d. R b d /\ R c d
   
   [HASH_DEF]  Definition  [oracles: ] [axioms: ] [] |- $# = ii_internalcl2
   
   [IDEF]  Definition  [oracles: ] [axioms: ] [] |- I = S # K # K
   
   [K]  Definition  [oracles: ] [axioms: ] [] |- K = ii_internalcl1
   
   [RTC]
   Definition
   [oracles: ] [axioms: ] []
   |- RTC =
      (\R a0 a1.
         !RTC'.
           (!a0 a1.
              R a0 a1 \/ (a1 = a0) \/ (?z. RTC' a0 z /\ RTC' z a1) ==>
              RTC' a0 a1) ==>
           RTC' a0 a1)
   
   [S]  Definition  [oracles: ] [axioms: ] [] |- S = ii_internalcl0
   
   [TC]
   Definition
   [oracles: ] [axioms: ] []
   |- TC =
      (\R a0 a1.
         !TC'.
           (!a0 a1. R a0 a1 \/ (?z. TC' a0 z /\ R z a1) ==> TC' a0 a1) ==>
           TC' a0 a1)
   
   [cl_TY_DEF]
   Definition
   [oracles: ] [axioms: ] []
   |- ?rep.
        TYPE_DEFINITION
          (\a0'.
             !'cl'.
               (!a0'.
                  (a0' = CONSTR 0 (@x. T) (\n. BOTTOM)) \/
                  (a0' = CONSTR (SUC 0) (@x. T) (\n. BOTTOM)) \/
                  (?a0 a1.
                     (a0' =
                      (\a0 a1.
                         CONSTR (SUC (SUC 0)) (@x. T)
                           (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                     'cl' a0 /\ 'cl' a1) ==>
                  'cl' a0') ==>
               'cl' a0') rep
   
   [cl_case_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (!v v1 f. cl_case v v1 f S = v) /\
      (!v v1 f. cl_case v v1 f K = v1) /\
      !v v1 f a0 a1. cl_case v v1 f (a0 # a1) = f a0 a1
   
   [cl_repfns]
   Definition
   [oracles: ] [axioms: ] []
   |- (!a. ii_internal_mk_cl (ii_internal_dest_cl a) = a) /\
      !r.
        (\a0'.
           !'cl'.
             (!a0'.
                (a0' = CONSTR 0 (@x. T) (\n. BOTTOM)) \/
                (a0' = CONSTR (SUC 0) (@x. T) (\n. BOTTOM)) \/
                (?a0 a1.
                   (a0' =
                    (\a0 a1.
                       CONSTR (SUC (SUC 0)) (@x. T)
                         (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                   'cl' a0 /\ 'cl' a1) ==>
                'cl' a0') ==>
             'cl' a0') r =
        (ii_internal_dest_cl (ii_internal_mk_cl r) = r)
   
   [cl_size_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (cl_size S = 0) /\ (cl_size K = 0) /\
      !a0 a1. cl_size (a0 # a1) = 1 + (cl_size a0 + cl_size a1)
   
   [ii_internalcl0_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalcl0 = ii_internal_mk_cl (CONSTR 0 (@x. T) (\n. BOTTOM))
   
   [ii_internalcl1_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalcl1 =
      ii_internal_mk_cl (CONSTR (SUC 0) (@x. T) (\n. BOTTOM))
   
   [ii_internalcl2_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalcl2 =
      (\a0 a1.
         ii_internal_mk_cl
           ((\a0 a1.
               CONSTR (SUC (SUC 0)) (@x. T)
                 (FCONS a0 (FCONS a1 (\n. BOTTOM))))
              (ii_internal_dest_cl a0) (ii_internal_dest_cl a1)))
   
   [preduce]  Definition  [oracles: ] [axioms: ] [] |- $===>* = TC $===>
   
   [reduce]  Definition  [oracles: ] [axioms: ] [] |- $--->* = RTC $--->
   
   [CHURCH_ROSSER]  Theorem  [oracles: ] [axioms: ] [] |- CR $--->*
   
   [CR_LEMMA]
   Theorem
   [oracles: ] [axioms: ] []
   |- !R. CR R ==> !a c. TC R a c ==> !b. R a b ==> ?d. TC R b d /\ R c d
   
   [NOT_C_CR]  Theorem  [oracles: ] [axioms: ] [] |- ~CR $--->
   
   [RED_EQ_PRED]
   Theorem
   [oracles: ] [axioms: ] [] |- !U V. U --->* V = U ===>* V
   
   [TC_PRESERVES_CR]
   Theorem
   [oracles: ] [axioms: ] [] |- !R. CR R ==> CR (TC R)
   
   [cl_11]
   Theorem
   [oracles: ] [axioms: ] []
   |- !a0 a1 a0' a1'. (a0 # a1 = a0' # a1') = (a0 = a0') /\ (a1 = a1')
   
   [cl_Axiom]
   Theorem
   [oracles: ] [axioms: ] []
   |- !f0 f1 f2.
        ?fn.
          (fn S = f0) /\ (fn K = f1) /\
          !a0 a1. fn (a0 # a1) = f2 a0 a1 (fn a0) (fn a1)
   
   [cl_case_cong]
   Theorem
   [oracles: ] [axioms: ] []
   |- !f' f v1' v1 v' v M' M.
        (M = M') /\ ((M' = S) ==> (v = v')) /\ ((M' = K) ==> (v1 = v1')) /\
        (!a0 a1. (M' = a0 # a1) ==> (f a0 a1 = f' a0 a1)) ==>
        (cl_case v v1 f M = cl_case v' v1' f' M')
   
   [cl_distinct]
   Theorem
   [oracles: ] [axioms: ] []
   |- ~(S = K) /\ (!a1 a0. ~(S = a0 # a1)) /\ !a1 a0. ~(K = a0 # a1)
   
   [cl_induction]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P. P S /\ P K /\ (!c c0. P c /\ P c0 ==> P (c # c0)) ==> !c. P c
   
   [cl_nchotomy]
   Theorem
   [oracles: ] [axioms: ] []
   |- !c. (c = S) \/ (c = K) \/ ?c' c0. c = c' # c0
   
   [preduce_HAS_CR]  Theorem  [oracles: ] [axioms: ] [] |- CR $===>*
   
   
*)
end
