val _ = quietdec := true;
val _ = print "Rebinding \"use\" for quotation pre-processing.\n"

(*---------------------------------------------------------------------------*
 * A version of "use" that filters quotations. The native MoscowML version   *
 * of "use" is found in the "Meta" structure.                                *
 *---------------------------------------------------------------------------*)
local fun grepfor s = "grep -c '\\`\\`' "^s
      fun has_dblquote s = 
          "if [ `"^grepfor s ^"` -ne 0 ] ; \
          \    then exit 0; \
          \    else exit 1; \
          \ fi"
      fun mkPath p = Path.toString(Path.fromString p)
      val enquoter = 
        mkPath(Globals.HOLDIR^"/src/quote-filter/enquote.")^Globals.archOS
in
fun use s = 
  if (Process.system (has_dblquote s) = Process.success)
  then let val filename = mkPath(FileSys.tmpName()^"hol98")
       in 
         (Process.system 
             (String.concat["(",enquoter," < ",s,") > ",filename]);
          Meta.use filename; 
          FileSys.remove filename
         )
         handle e 
         => (FileSys.remove filename handle _ => (); raise e)
       end
  else Meta.use s
end;

val _ = quietdec := false;
