structure pair_caseScript =
struct

open Parse Thm Theory Const_def Rewrite;
infix THEN;

val _ = new_theory "pair_case";

(*---------------------------------------------------------------------------
 * For TFL termination condition extraction. PAIR_CASE is equal to UNCURRY, but
 * the rewriter for t-c. extraction needs to distinguish ordinary tuples from
 * applications of PAIR_CASE.
 *---------------------------------------------------------------------------*)
val PAIR_CASE_DEF = 
  new_definition("PAIR_CASE_DEF", Term`PAIR_CASE = UNCURRY`);

val PAIR_CASE_THM = save_thm("PAIR_CASE_THM",
   Rewrite.REWRITE_RULE [pairTheory.UNCURRY_DEF] 
      (MK_COMB(MK_COMB (PAIR_CASE_DEF, REFL(Term`f:'a->'b ->'c`)),
               REFL (Term`(x,y)`))));

val _ = export_theory()

end;
