(*---------------------------------------------------------------------------*
 * Sudan's function, which is similar to Ackermann's function. Apparently,   *
 * both Sudan and Ackermann were students of Hilbert and came up with their  *
 * functions about the same time, but Hilbert preferred Ackermann's.         *
 *---------------------------------------------------------------------------*)

load "tflLib"; open tflLib;

val Sudan_def = Rfunction "Sudan_def" `^pred ** (inv_image ^pred SND)`
`(Sudan 0 (x,y)           = x+y) /\
 (Sudan (SUC n) (x,0)     = x)   /\
 (Sudan (SUC n) (x,SUC y) = Sudan n (Sudan (SUC n) (x,y), 
                                     Sudan (SUC n) (x,y) + SUC y))`;

val eqns = save_thm("Sudan_eqns", #rules Sudan_def);
val induction = save_thm("Sudan_induction", #induction Sudan_def);

