/*************************************************************************
  $Header$
  FILE:  tree.c
  DESCR: Trees for BDD variables
  AUTH:  Jorn Lind
  DATE:  (C) march 1998
*************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "tree.h"

/*************************************************************************
*************************************************************************/

/*======================================================================*/

BddTree *bddtree_new(void)
{
   BddTree *t = (BddTree*)(malloc(sizeof(BddTree)));
   if (t == NULL)
      return NULL;

   t->first = t->last = -1;
   t->next = t->nextlevel = NULL;
   return t;
}


void bddtree_del(BddTree *t)
{
   if (t == NULL)
      return;
   
   bddtree_del(t->nextlevel);
   bddtree_del(t->next);
   free(t);
}


BddTree *bddtree_addrange(BddTree *t, int first, int last)
{
   if (first < 0  ||  last < 0  ||  last < first)
      return NULL;

      /* Empty tree -> build one */
   if (t == NULL)
   {
      t = bddtree_new();
      t->first = first;
      t->last = last;
      return t;
   }

   if (first == t->first  &&  last == t->last)
      return t;
   
      /* Before this section -> insert */
   if (last < t->first)
   {
      BddTree *tnew = bddtree_new();
      tnew->first = first;
      tnew->last = last;
      tnew->next = t;
      return tnew;
   }

      /* After this this section -> go to next */
   if (first > t->last)
   {
      t->next = bddtree_addrange(t->next, first, last);
      return t;
   }

      /* Inside this section -> insert in next level */
   if (first >= t->first  &&  last <= t->last)
   {
      t->nextlevel = bddtree_addrange(t->nextlevel, first, last);
      return t;
   }

      /* Covering this section -> insert above this level */
   if (first <= t->first)
   {
      BddTree *tnew;
      BddTree *this = t;

      while (1)
      {
	    /* Partial cover ->error */
	 if (last >= this->first  &&  last < this->last)
	    return NULL;

	 if (this->next == NULL  ||  last < this->next->first)
	 {
	    tnew = bddtree_new();
	    if (tnew == NULL)
	       return NULL;
	    tnew->first = first;
	    tnew->last = last;
	    tnew->nextlevel = t;
	    tnew->next = this->next;
	    this->next = NULL;
	    return tnew;
	 }
	 
	 this = this->next;
      }
      
   }
      
   return NULL;
}


void bddtree_print(FILE *o, BddTree *t, int level)
{
   if (t == NULL)
      return;

   fprintf(o, "%*s%3d\n", level*3, "", t->first);
   bddtree_print(o, t->nextlevel, level+1);
   fprintf(o, "%*s%3d\n", level*3, "", t->last);
   bddtree_print(o, t->next, level);
   
#if 0
   fprintf(o, "(%d, ", t->first);
   bddtree_print(o, t->nextlevel);
   fprintf(o, ", %d)", t->last);
   bddtree_print(o, t->next);
#endif
}


int main(void)
{
   BddTree *t = NULL;

   t = bddtree_addrange(t, 8,10);
   printf("A\n"); bddtree_print(stdout, t, 0);
   t = bddtree_addrange(t, 2,99);
   printf("B\n"); bddtree_print(stdout, t, 0);
   t = bddtree_addrange(t, 11,50);
   printf("C\n"); bddtree_print(stdout, t, 0);
   t = bddtree_addrange(t, 5,7);
   printf("D\n"); bddtree_print(stdout, t, 0);
   t = bddtree_addrange(t, 5,10);
   printf("E\n"); bddtree_print(stdout, t, 0);
   t = bddtree_addrange(t, 100,150);
   printf("F\n"); bddtree_print(stdout, t, 0);
   t = bddtree_addrange(t, 60,65);
   printf("G\n"); bddtree_print(stdout, t, 0);
   t = bddtree_addrange(t, 1,200);

   printf("G\n"); bddtree_print(stdout, t, 0);
   bddtree_del(t);
   return 0;
}


/* EOF */
