/*************************************************************************
  $Header: /home/jl/phd/bdd/RCS/cache.h,v 1.5 1997/11/04 10:18:34 jl Exp jl $
  FILE:  cache.h
  DESCR: Cache class for caching apply/exist etc. results
  AUTH:  Jorn Lind
  DATE:  (C) june 1997
*************************************************************************/

#ifndef _CACHE_H
#define _CACHE_H

typedef struct
{
   union
   {
      double dres;
      int res;
   } r;
   int a,b,c;
} BddCacheData;


typedef struct
{
   BddCacheData *table;
   int tablesize;
} BddCache;


extern int           BddCache_init(BddCache *, int);
extern void          BddCache_reset(BddCache *);
extern void          BddCache_done(BddCache *);

#define BddCache_lookup(cache, hash) (&(cache)->table[hash % (cache)->tablesize])



#endif /* _CACHE_H */


/* EOF */
