structure DecideNum =
struct

local

open Exception Term Dsyntax Theory Rewrite
     Psyntax Conv DecisionConv DecisionSupport NumArith NumArithCons;
infix THENC;
infix ORELSEC;

local
   open NumHOLType
in
   val unops = [suc,pre]
   and binops = [plus,minus,less,leq,great,geq]
end;


fun num_discrim tm =
   let val (f,args) = strip_comb tm
   in  case (length args)
       of 0 => if (NumArithCons.is_num_var f) orelse
                  (NumArithCons.is_num_const f)
               then (fn _ => tm,[])
               else Decide.failwith "num_discrim"
        | 1 => if (is_const f) andalso
                  (member (#Name (Rsyntax.dest_const f)) unops)
               then (fn args' => list_mk_comb (f,args'),args)
               else Decide.failwith "num_discrim"
        | 2 => if (is_const f)
               then let val nom = #Name(Rsyntax.dest_const f)
                    in if (NumHOLType.mult = nom) 
                       then if (is_num_const (hd args) orelse 
                                is_num_const (hd(tl args)))
                            then  (fn args' => list_mk_comb (f,args'),args)
                            else Decide.failwith "num_discrim"
                       else if (member nom binops)
                            then (fn args' => list_mk_comb (f,args'),args)
                             else Decide.failwith "num_discrim"
                    end
               else Decide.failwith "num_discrim"
(*        | 2 => if (is_const f) andalso
                  (member (#Name (Rsyntax.dest_const f)) binops)
               then (fn args' => list_mk_comb (f,args'),args)
               else Decide.failwith "num_discrim"
*)
        | _ => Decide.failwith "num_discrim"
   end;

in

val SUB_NORM_CONV =
 GEN_REWRITE_CONV Lib.I Rewrite.empty_rewrites
 [arithmeticTheory.SUB_LEFT_ADD,          arithmeticTheory.SUB_RIGHT_ADD,
  arithmeticTheory.SUB_LEFT_SUB,          arithmeticTheory.SUB_RIGHT_SUB,
  arithmeticTheory.LEFT_SUB_DISTRIB,      arithmeticTheory.RIGHT_SUB_DISTRIB,
  arithmeticTheory.SUB_LEFT_SUC,
  arithmeticTheory.SUB_LEFT_LESS_EQ,      arithmeticTheory.SUB_RIGHT_LESS_EQ,
  arithmeticTheory.SUB_LEFT_LESS,         arithmeticTheory.SUB_RIGHT_LESS,
  arithmeticTheory.SUB_LEFT_GREATER_EQ,  arithmeticTheory.SUB_RIGHT_GREATER_EQ,
  arithmeticTheory.SUB_LEFT_GREATER,      arithmeticTheory.SUB_RIGHT_GREATER,
  arithmeticTheory.SUB_LEFT_EQ,           arithmeticTheory.SUB_RIGHT_EQ,
  arithmeticTheory.PRE_SUB1
 ];

(*--------------------------------------------------------------------------*)
(* REDEPTH_CONV is more efficient than TOP_DEPTH_CONV. Also, with           *)
(* TOP_DEPTH_CONV special measures are required to avoid looping, and       *)
(* conditional expression elimination has to be included.                   *)
(*--------------------------------------------------------------------------*)

val SUB_ELIM_CONV =
   REDEPTH_CONV
      (SUB_NORM_CONV ORELSEC
       DecisionArithConvs.NUM_COND_RATOR_CONV ORELSEC
       DecisionArithConvs.NUM_COND_RAND_CONV ORELSEC
       NormalizeBool.COND_ABS_CONV);

val ARITH_NORM_CONV = RULE_OF_CONV ARITH_LITERAL_NORM_CONV;

local

open NumArithCons LazyThm;

val mk_one = mk_const (NumHOLType.one,NumHOLType.num_ty);

in

fun ARITH_FALSE_CONV tm =
   if ((is_eq o dest_neg o #1 o dest_conj) tm handle HOL_ERR _ => false)
   then
   let val (diseq,conj) = dest_conj tm
       val (l,r) = dest_eq (dest_neg diseq)
       val disjl = mk_conj (mk_leq (mk_plus (mk_one,l),r),conj)
       and disjr = mk_conj (mk_leq (mk_plus (mk_one,r),l),conj)
       fun rule thl thr =
          RIGHT_CONV_RULE
             (LEFT_CONV (fn _ => thl) THENC RIGHT_CONV (fn _ => thr) THENC
              DecisionNormConvs.OR_F_CONV)
             ((LEFT_CONV (DecisionArithConvs.NOT_NUM_EQ_NORM_CONV) THENC
               DecisionNormConvs.RIGHT_DISJ_NORM_CONV) tm)
   in  apply_rule2 (fn _ => fn _ => ([],mk_eq (tm,F)),rule)
          (INEQS_FALSE_CONV disjl) (INEQS_FALSE_CONV disjr)
   end
   else INEQS_FALSE_CONV tm;

end;

val num_proc =
   {Name = "num",
    Description = "Linear arithmetic over natural numbers",
    Author = "Richard J. Boulton",
    Discriminator = num_discrim,
    Normalizer = SUB_ELIM_CONV THENC
                 NormalizeBool.EXPAND_BOOL_CONV NormalizeBool.Disjunctive
                    ARITH_NORM_CONV,
    Procedure = Decide.make_incremental_procedure LazyRules.CONJ
                   ARITH_FALSE_CONV}

end;

end; (* DecideNum *)
