signature Facts =
sig
 type term = Term.term
 type thm = Thm.thm

  type tyinfo
  type factBase

 
  val mk_facts : {datatype_ax:thm,
                  case_def: thm,
                  one_one : thm option,
                  distinct: thm option} -> tyinfo

  val ty_name_of      :tyinfo -> string
  val axiom_of        :tyinfo -> thm
  val constructors_of :tyinfo -> term list
  val case_const_of   :tyinfo -> term
  val case_cong_of    :tyinfo -> thm
  val case_def_of     :tyinfo -> thm
  val induction_of    :tyinfo -> thm
  val nchotomy_of     :tyinfo -> thm
  val distinct_of     :tyinfo -> thm option
  val one_one_of      :tyinfo -> thm option
  val simpls_of       :tyinfo -> thm list
  val size_of         :tyinfo -> (term * thm) option

  val put_nchotomy  : thm -> tyinfo -> tyinfo
  val put_induction : thm -> tyinfo -> tyinfo
  val put_simpls    : thm list -> tyinfo -> tyinfo
  val put_size      : term * thm -> tyinfo -> tyinfo

  val empty : factBase
  val add   : factBase -> tyinfo -> factBase
  val get   : factBase -> string -> tyinfo option
  val elts  : factBase -> tyinfo list
  
end;
