signature Datatype =
sig
 type term = Term.term
 type tyinfo = Facts.tyinfo
 type hol_type = Type.hol_type
 type factBase = Facts.factBase
 type 'a quotation = term frag list;
 
  (* "Pure" operations that do not use the underlying database of facts *)

  val primHol_datatype : factBase -> term quotation -> tyinfo
  val type_size    : factBase -> hol_type -> term

  (* Imperative database of datatype facts and associated operations. *)
  val theFactBase : unit -> factBase
  val add          : tyinfo -> unit
  val get          : string -> tyinfo option
  val Hol_datatype : term quotation -> unit
 
  (* The database comes preloaded with facts for bool, pairs, num, and lists *)
end;
