(* ===================================================================== *)
(* FILE          : prim_rec.sig                                          *)
(* DESCRIPTION   : Signature for primitive recursive definitions over    *)
(*                 recursive types. Translated from hol88.               *)
(*                                                                       *)
(* AUTHOR        : (c) Tom Melham, University of Cambridge 1987          *)
(* TRANSLATOR    : Konrad Slind, University of Calgary                   *)
(* DATE          : September 11, 1991                                    *)
(* ===================================================================== *)


signature Prim_rec =
sig
  val prove_rec_fn_exists : Thm.thm -> Term.term -> Thm.thm
  val new_recursive_definition 
       : {name      : string, 
          fixity    : Term.fixity,
          rec_axiom : Thm.thm,
          def       : Term.term} -> Thm.thm
   val INDUCT_THEN : Thm.thm -> (Thm.thm -> Abbrev.tactic) -> Abbrev.tactic
   val prove_induction_thm : Thm.thm -> Thm.thm
   val prove_cases_thm : Thm.thm -> Thm.thm
end;
