signature TheoryPP =
sig
(*
  structure Thm : Thm_sig
*)
  type hol_type = Type.hol_type
  type fixity   = Term.fixity
  type thm      = Thm.thm

  val pp_theory_sig : Portable_PrettyPrint.ppstream 
                        -> {name       : string,
                            parents    : string list,
                            axioms     : (string * thm) list,
                            definitions: (string * thm) list,
                            theorems   : (string * thm) list,
                            sig_ps     : (Portable_PrettyPrint.ppstream 
					  -> unit)option} -> unit
      
  val pp_theory_struct : Portable_PrettyPrint.ppstream 
                        -> {theory     :string*int*int,
			    parents    :(string*int*int) list,
			    types      :(string*int) list,
			    constants  :(string*hol_type*fixity) list,
			    axioms     :(string * thm) list,
			    definitions:(string * thm) list,
			    theorems   :(string * thm) list,
			    struct_ps  : (Portable_PrettyPrint.ppstream 
					  -> unit) option} -> unit

end
