structure RawTokens :> RawTokens =
struct
  type svalue = RawParserData.svalue
  type ('a,'b) token = ('a,'b) Token.token

fun lambda (p1,p2) = Token.TOKEN (LRTable.T 0, (RawMlyValue.VOID,p1,p2))
fun lparen (p1,p2) = Token.TOKEN (LRTable.T 1,(RawMlyValue.VOID,p1,p2))
fun rparen (p1,p2) = Token.TOKEN (LRTable.T 2,(RawMlyValue.VOID,p1,p2))
fun dot (p1,p2) = Token.TOKEN (LRTable.T 3, (RawMlyValue.VOID,p1,p2))
fun dB_index(i,p1,p2) = Token.TOKEN(LRTable.T 4,(RawMlyValue.dB_index i,p1,p2))
fun atom_index(i,p1,p2)=Token.TOKEN(LRTable.T 5,
                                     (RawMlyValue.atom_index i,p1,p2))
fun num (i,p1,p2) = Token.TOKEN (LRTable.T 6,(RawMlyValue.num i,p1,p2))
fun string_ (i,p1,p2) = Token.TOKEN (LRTable.T 7,(RawMlyValue.string_ i,p1,p2))
fun EOLEX (p1,p2) = Token.TOKEN (LRTable.T 8,(RawMlyValue.VOID,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (LRTable.T 9,(RawMlyValue.VOID,p1,p2))

end
