structure RawTokens :> RawTokens =
struct
  type svalue = ParserData.svalue
  type ('a,'b) token = ('a,'b) Token.token

fun lambda (p1,p2) = Token.TOKEN (LRTable.T 0, (MlyValue.VOID,p1,p2))
fun lparen (p1,p2) = Token.TOKEN (LRTable.T 1,(MlyValue.VOID,p1,p2))
fun rparen (p1,p2) = Token.TOKEN (LRTable.T 2,(MlyValue.VOID,p1,p2))
fun dot (p1,p2) = Token.TOKEN (LRTable.T 3, (MlyValue.VOID,p1,p2))
fun dB_index (i,p1,p2) = Token.TOKEN (LRTable.T 4,(MlyValue.dB_index i,p1,p2))
fun atom_index(i,p1,p2)=Token.TOKEN(LRTable.T 5,(MlyValue.atom_index i,p1,p2))
fun num (i,p1,p2) = Token.TOKEN (LRTable.T 6,(MlyValue.num i,p1,p2))
fun string_ (i,p1,p2) = Token.TOKEN (LRTable.T 7,(MlyValue.string_ i,p1,p2))
fun EOLEX (p1,p2) = Token.TOKEN (LRTable.T 8,(MlyValue.VOID,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (LRTable.T 9,(MlyValue.VOID,p1,p2))

end
