(* ML-Yacc Parser Generator (c) 1989 Andrew W. Appel, David R. Tarditi 
 *
 * $Log: join.sml,v $
# Revision 1.1.1.1  1997/01/14  01:38:04  george
#   Version 109.24
#
 * Revision 1.1.1.1  1996/01/31  16:01:42  george
 * Version 109
 * 
 *)

structure RawParser :> RawParser =
struct
    exception ParseError = LRParser.ParseError

    type arg = ParserData.arg
    type pos = ParserData.pos
    type result = ParserData.result
    type svalue = ParserData.svalue

    val makeLexer = Stream.streamify o RawLex.makeLexer

    fun parse (lookahead,lexer,error,arg) =
      let val (a,b) = LRParser.parse 
                        {table = ParserData.table,
                         lexer = lexer,
                         lookahead = lookahead,
                         saction = Actions.actions,
                         arg = arg,
                         void = Actions.void,
                         ec = {is_keyword = EC.is_keyword,
                               noShift = EC.noShift,
                               preferred_change = EC.preferred_change,
                               errtermvalue = EC.errtermvalue,
                               error = error,
                               showTerminal = EC.showTerminal,
                         terms = EC.terms}}
      in
       (Actions.extract a,b)
      end;
     
     val sameToken = Token.sameToken
end;

