signature RawParser =
    sig
	exception ParseError

	(* type pos is the type of line numbers *)

	type pos = ParserData.pos

	(* type result is the type of the result from the parser *)

	type result = ParserData.result

         (* the type of the user-supplied argument to the parser *)
 	type arg = ParserData.arg
	
	(* type svalue is the type of semantic values for the semantic value
	   stack
	 *)

	type svalue = ParserData.svalue

	(* val makeLexer is used to create a stream of tokens for the parser *)

	val makeLexer : (int -> string) ->
			 (svalue,pos) RawTokens.token Stream.stream

	(* val parse takes a stream of tokens and a function to print
	   errors and returns a value of type result and a stream containing
	   the unused tokens
	 *)

	val parse : int * ((svalue,pos) Token.token Stream.stream)
                     * (string * pos * pos -> unit) * arg 
                    ->
                    result * (svalue,pos) RawTokens.token Stream.stream

	val sameToken : (svalue,pos)Token.token * (svalue,pos)Token.token -> bool
     end
