structure EC =
struct
open LRTable

val is_keyword = fn _ => false
val preferred_change = nil
val noShift = fn (T 9) => true | _ => false

val showTerminal = fn (T 0) => "lambda"
                    | (T 1) => "lparen"
                    | (T 2) => "rparen"
                    | (T 3) => "dot"
                    | (T 4) => "dB_index"
                    | (T 5) => "atom_index"
                    | (T 6) => "num"
                    | (T 7) => "string_"
                    | (T 8) => "EOLEX"
                    | (T 9) => "EOF"
                    | _ => "bogus-term"

local open Header 
in val errtermvalue = fn _ => MlyValue.VOID
end

val terms = (T 0) :: (T 1) :: (T 2) :: (T 3) :: (T 8) :: (T 9) :: nil

end (* EC *)
