
# Procedure: scrollable
#
# Synopsis:
#	Create a `scrollable' widget which may be added to or removed from
#	a larger display under user control.
#
# Usage:
#c	scrollable widgetType pathName ?option value?...
#
# Parameters:
#c	widgetType
#		A widget creation command such as `button' or `listbox'.
#
#c	pathName
#		Name of the frame in which the scrollable widget will be
#		created.
#
# Options:
#	Name:			horizontal
#	Class:			Horizontal
#	Command-Line Switch:	-horizontal
#
#	Name:			vertical
#	Class:			Vertical
#	Command-Line Switch:	-vertical
#
#	Other options are those accepted by the `widgetType' command.
#
# Description:
#
# Bugs:
#
#	- The collabsible processor does not honor the `configure' widget
#	command.
#
#	- The scrollable processor does not use the widget creation
#	definitions to make itself a first-class widget.

option add *Scrollable.vertical 1 widgetDefault
option add *Scrollable.horizontal 0 widgetDefault

proc scrollable {type w args} {
	global scrollable_priv

	global gui_flags

	if [winfo exists $w] { error "$w already exists"  }
	frame $w -class Scrollable

	set horizontal [option get $w horizontal Horizontal]
	set vertical [option get $w vertical Vertical]
	set fargs {}

	while {[llength $args] >= 2} {
		set option [lindex $args 0]
		set value [lindex $args 1]
		set args [lrange $args 2 end]
		case $option in {
			-horizontal { set horizontal $value }
			-vertical { set vertical $value }
			default {
				lappend fargs $option $value
			}
		}
	}

	if {$vertical} {
	    pack \
		[scrollbar $w.vscroll -relief sunken -command "$w.b yview"] \
		-side $gui_flags(scrollbarSide) -fill y
		lappend fargs -yscroll "$w.vscroll set"
	} 
	if {$horizontal} {
	    pack \
		[scrollbar $w.hscroll -relief sunken -orient horiz -command "$w.b xview"] \
		-side bottom -fill x
		lappend fargs -xscroll "$w.hscroll set"
        }
	set subw [eval [list $type $w.b] $fargs]
	pack $subw -expand yes -fill both
	return $w
}
