#-------------------------------------------------------------
# setup.tcl
#
# This program is a Tcl script.
#-------------------------------------------------------------

if [catch {source ../.tkholinstall}] {
	puts stderr "You should run ./configure before running setup."
	exit 1
}

set applychanges 0
for {set i 0} {$i<[llength $argv]} {incr i} {
    case [lindex $argv $i] -applychanges {
	set applychanges 1
    } default {
	puts stderr "Unrecognized argument [lindex $argv $i]"
    }
}

if [file exists ./install.tcl] {
    set topdir .
} else {
    set topdir rfiles_TkHolWorkbench
}

source $topdir/install.tcl
source $topdir/version.tcl
source $topdir/patchlevel.tcl

# Define app name and install save file
install_init TkHolWorkbench ../.tkholinstall ../.tkholinstall.sh

install_version	version 		VERSION 	$version {TkHolWorkbench Version number}
install_var	gui_flags(maintainer) 	MAINTAINER 	Donald.Syme@cl.cam.ac.uk {Target of error mailings}
install_var gui_flags(install_dir) 	INSTALL_DIR 	"" {Root Installation Directory}
 
install_var make(target)  		MAKE_TARGET 	all {make: target}
install_progVar	TkHolSlave_flags(default_hol88) HOL88 	"hol88" {make: hol88 executable}
install_progVar	TkHolSlave_flags(default_hol90) HOL90 	"hol90" {make: hol90 executable}
install_var gui_flags(arch)  		ARCH 		"" {make: architecture}
install_var gui_flags(LispDir)		LispDir 	"" {make: hol88 Lisp .o Files}
install_progVar	 gui_flags(flex)	FLEX 		""                   {make: flex lexical analyser}
install_progVar gui_flags(expectk)	EXPECTK 	""  {runtime: expectk executable}
install_var gui_flags(TCL_LIBRARY)	TCL_LIBRARY 	""  {runtime: TCL library directory}
install_var gui_flags(TK_LIBRARY)	TK_LIBRARY 	""  {runtime: TK library directory}

install_progVar	TkHolSlave_flags(default_hol) HOL 	"hol88" {runtime: Default HOL executable}
install_progVar	gui_flags(wwwBrowser) WWW_BROWSER 	"xmosaic" {runtime: Default WWW browser}
install_var	HolHelp_flags(lal_URL) LAL_URL 	"" {runtime: Default HOL Help URL}
install_var	HolHelp_flags(hol90_URL) HOL90_URL 	"" {runtime: Default HOL 90 Help URL}

install_sed  .MASTER	bin/runpackages \
			bin/runpackages.tcl \
			bin/tkholwb \
			bin/tkholshell \
			bin/tkholhelper \
			Makefile \
			HolRichText/Makefile \
			TkHolSlave/Makefile \
			TkTRS/trs90/Makefile \
			HolTheoryNotification/Makefile

# Define test command
install_test exec ./bin/tkholwb
install_make run_make

proc run_make { } {
    global make
    exec make $make(target) >&@ stdout
}

# User information

install_help {
-------------------------------------------------------------------------
              Welcome to TkHolWorkbench Setup.  

This    tool   helps   you   configure,   make   and   install
TkHolWorkbench  on  your system. TkHolWorkbench should be easy
to  install,  but  if  you  have  problems  please  read these
installation notes with care before giving up.

NOTE:  If  you  don't  like  using this setup program, you may
instead   patch   and  make  the  system  manually.  The  main
advantage   in   using  "setup"  is  that  it  remembers  your
configuration   settings   between   different  versions.  The
configuration    options    are    stored    in    the   files
".tkholinstall"   and   ".tkholinstall.sh"  in  the  directory
above this one.
-------------------------------------------------------------------------

Adjust  each  parameter  below  so  it  is  correct  for  your
system.  Each  entry  is  used  to  patch  the  TkHolWorkbench
source  files  and to control what parts of TkHolWorkbench are
"made".

After you set things up, then:
	1. Apply Changes - apply the specified site-dependent 
   	   changes to the TkHolWorkbench source files.
	2. Run make - try to compile the few things that need 
	   compiling.
	3. Run Test - run the patched tkholwb script to 
	   check everything is OK.

The  "hol88  Lisp  .o  Files"  entry  is only needed if you're
compiling  for  "hol88"  or  "all".  This  is  needed  because
TkHolWorkbench  includes  some  lisp  extensions which need to
access  the  compiled  lisp  .o  files  from  the  HOL  source
directories  to  compile.  The lisp/ directory underneath this
directory  must  contain  the  lisp  .o  files  for  the hol88
sytem. Ignore this entry if you are not using hol88.

The  make  target you specify should match the HOL systems you
plan to use with TkHolWorkbench.  

The  "hol88  Executable"  entry  need only be given if you are
making   the  system  for  hol88  or  both  hol88  and  hol90.
Similarly,  the  "hol90  Executable"  entry need only be given
if  you  are  making  the  system  for hol90 or both hol88 and
hol90.

You  should  rerun  "./configure"  and "./setup" each time you
install a new version of TkHolWorkbench.
}

# Reread these to ignore the settings in .tkholinstall
source $topdir/version.tcl
source $topdir/patchlevel.tcl

# Go for it, either applying the changes directly or running the dialog.
if {$applychanges} {
	wm withdraw .
	install_dialog
	installSave
	installSed
	exit
} else {
	install_dialog
}
