
#----------------------------------------------------------------------------
#
# WIDGET CLASS listedit
# 
# CONFIGURATION OPTIONS
#
#	All "listbox" options plus:
#
#		-variable
#
#		
# WIDGET COMMAND
#
# EXAMPLE
#
# set ledit [list Moose {Apple Pie}]
# listeditor .top.t -variable ledit
# lappend ledit {Custard Tart}
#----------------------------------------------------------------------------

option add *ListEditor.variable listeditorvar widgetDefault

proc listeditor { w args } {

	global vals
	global gui_flags 

	set passon_args ""
	for {set i 0} {$i<[llength $args]} {incr i} {
	    switch -- [lindex $args $i] -variable {
	        incr i
	        set vals($w,variable) [lindex $args $i]
	    } default {
	        lappend passon_args [lindex $args $i]
		incr i
	        lappend passon_args [lindex $args $i]
	    }
	}
	frame $w -class ListEditor
	if ![info exists vals($w,variable)] { set vals($w,variable) [option get $w variable Variable] }
	
	pack [frame $w.fr] -side left -expand yes -fill both        
    	pack [entry $w.entry \
		-textvariable vals($w,entry) \
		-relief sunken \
		-borderwidth 2 \
		-font $gui_flags(font,textentry)] \
	    -fill x -in $w.fr
	
        pack [eval [list scrollable listbox $w.listbox \
		-font $gui_flags(font,listboxes) \
		-borderwidth 2 \
		-relief sunken] $passon_args] \
	   -side left -in $w.fr -expand yes -fill both

    	pack [frame $w.buttons] \
	    -side right -pady 5 -padx 5

    	pack [button $w.buttons.insert \
		-width 6 \
		-text Insert \
		-command "listeditor::insert $w" \
		-font $gui_flags(font,buttons)] \
	    -side top

    	pack [button $w.buttons.change \
		-width 6 \
		-text Change \
		-command "listeditor::change $w" \
		-font $gui_flags(font,buttons)] \
	    -side top

    	pack [button $w.buttons.delete \
		-width 6 \
		-text Delete \
		-command "listeditor::delete $w" \
		-font $gui_flags(font,buttons)] \
	    -side top

    	pack [button $w.buttons.sort \
		-width 6 \
		-text Sort \
		-command "listeditor::sort $w" \
		-font $gui_flags(font,buttons)] \
	    -side top

    	# bindings
    	bind $w.listbox.b <Any-B1-Motion> \
		[list listeditor::select $w %y]
    	bind $w.listbox.b <Any-Button-1> \
		[list listeditor::select $w %y]

    	bind $w.entry <Any-Return> "listeditor::insert $w"
    
    	upvar #0 $vals($w,variable) var
	if {![info exists var]} { set var "" }
	listeditor::variable_change $w
	trace variable var w "listeditor::variable_change $w"
	
    	bind $w <Destroy> "unset_vals_for_widget $w; 
		trace vdelete $vals($w,variable) w \"listeditor::variable_change $w\"
    	"
    	return $w
}

proc listeditor::select { w y } {
	global vals
    	upvar #0 vals($w,entry) entryvar
    	set i [$w.listbox.b nearest $y]
    	$w.listbox.b select from $i
    	set entryvar [$w.listbox.b get $i]
}

proc listeditor::insert { w } {
	global vals
    	upvar #0 $vals($w,variable) var
    	lappend var [$w.entry get]
	
}

proc listeditor::change { w } {
	global vals
    	upvar #0 $vals($w,variable) var
	set var [lreplace $var [$w.listbox.b cursel] [$w.listbox.b cursel] [$w.entry get]]
}

proc listeditor::delete { w } {
	global vals
    	upvar #0 $vals($w,variable) var
	set var [lreplace $var [$w.listbox.b cursel] [$w.listbox.b cursel]]
}
proc listeditor::sort { w } {
	global vals
    	upvar #0 $vals($w,variable) var
	set var [lsort $var]
}


proc listeditor::variable_change { w args } {
	global vals

	set sel [$w.listbox.b cursel]
#	if {$sel==""} { set sel 0 }
		
    	upvar #0 $vals($w,variable) var
	$w.listbox.b delete 0 end
	foreach el $var {
		$w.listbox.b insert end $el
	}
	catch {
    	    upvar #0 vals($w,entry) entryvar
	    $w.listbox.b select from $sel;
    	    set entryvar [$w.listbox.b get $sel]
	}
}

