(* matching.ml                                           (c) R.J.Boulton 1990 *)
(*----------------------------------------------------------------------------*)

signature TRS_matching_sig =
sig
	(* Datatype for a full representation of a theorem *)

	(* The first string is for the theory name. The second is for the theorem *)
	(* name.                                                                  *)

	datatype thmkind = Axiom | Definition | Theorem;

	type thmpattern;
    
	exception sidematch_FAIL;
	exception BAD_SIDE_CONDITION;

   	val Kind : thmkind -> thmpattern
   	val Thryname : TRS_name.namepattern -> thmpattern
   	val Thmname : TRS_name.namepattern -> thmpattern
   	val Conc : TRS_struct.termpattern -> thmpattern
   	val HypP : TRS_struct.termpattern list -> thmpattern
   	val HypF : TRS_struct.termpattern list -> thmpattern
   	val Side : side_condition -> thmpattern
   	val Andalso : (thmpattern * thmpattern) -> thmpattern
   	val Orelse : (thmpattern * thmpattern) -> thmpattern
   	val Not : thmpattern -> thmpattern
	val Where : (thmpattern * thmpattern) -> thmpattern
   	val thmmatch : thmpattern -> (thmkind * (string * (string * Thm.thm))) -> bool
 	val thmfilter : thmpattern -> (thmkind * (string * (string * Thm.thm))) list -> 
					(thmkind * (string * (string * Thm.thm))) list
end;


