%############################################################################%
%   fconcatl.ml,v 1.2 1995/02/17 16:39:11 drs1004 Exp		     %
%    Copyright (C) 1994  Donald Syme					     %
%									     %
%    This program is free software; you can redistribute it and/or modify    %
%    it under the terms of the GNU General Public License as published by    %
%    the Free Software Foundation; either version 1, or (at your option)     %
%    any later version.							     %
%									     %
%    This program is distributed in the hope that it will be useful,	     %
%    but WITHOUT ANY WARRANTY; without even the implied warranty of	     %
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	     %
%    GNU General Public License for more details.			     %
%									     %
%    You should have received a copy of the GNU General Public License	     %
%    along with this program; if not, write to the Free Software	     %
%    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     %
%									     %
%    Contact Details:							     %
%	Donald Syme							     %
%	The Computer Laboratory						     %
%	New Musuems Site						     %
%	Pembroke St.							     %
%	Cambridge U.K. CB2 3QG						     %
%									     %
%	email: Donald.Syme@cl.cam.ac.uk					     %
%									     %
%############################################################################%


%-----------------------------------------------------------------------%
% concatl								%
% Fast concatl based on lisp code qconcatl.  Maybe doesn't work	        %
% for all characters in strings???              			%
%-----------------------------------------------------------------------%

letrec concatl l =
	if ((length l) > 50)  then
		let (pt1,pt2) = chop_list 50 l in
		concatl [qconcatl pt1; concatl pt2]
	else (qconcatl l);;

%< 
concatl (replicate `a` 1000);;
concatl (replicate `aaaaaaaaaaaaaaa` 100);;
concatl (replicate (implode (replicate `a` 1000)) 2);;
>%

%-----------------------------------------------------------------------%
%									%
%-----------------------------------------------------------------------%

let string_list_to_tcl_list sl = concatl (flat (map (\s. [`{`; s; `} `]) sl));;

