#----------------------------------------------------------------------------
# WIDGET CLASS TheoremSaveBox
#
#	A box containing items specifying where to save a theorem to.
#
#	The box does not destroy itself.  It sets a global variable
#	which may be traced by trace or widget_waitVariable or a similar
#	mechanism.
#
# CONFIGURATION OPTIONS
#
#	-header
#		Some text printed at the top of the box as a message.
#
#	-resultsvariable
#
#		This variable is set when either the OK or Cancel
#		buttons are pressed.  It is set to a 4-tuple
#		containing the name of the button pressed, a boolean
#		value indicating whether the save checkbox was
#		selected, the text typed into the save-name field
#		a boolean value indicating whether the bind field
#		was selected.  If Cancel was pressed then the tuple
#		only contains one element.
#
#		The widget checks that a save name has been entered
#		if the save field has been selected, and that the name
#		is a valid ML identifier.
#		
# WIDGET COMMAND
# 
# EXAMPLE
#
#	modalDialog transient TheoremSaveBox $w.save \
#		-header "Goal Proved!" \
#		-resultsvariable vals($w,waiter)
#	widget_waitVariable vals($w,waiter)
#	modalDialog.end $w.save
#	switch -- [lindex $vals($w,waiter) 0] Ok { ... } Cancel { ... }
#----------------------------------------------------------------------------

option add *TheoremSaveBox.header "" widgetDefault
option add *TheoremSaveBox.resultsvariable results widgetDefault


proc TheoremSaveBox { w args } {
	global vals 
	global gui_flags


	for {set i 0} {$i<[llength $args]} {incr i} {
	    switch -- [lindex $args $i] -header {
	        incr i
	        set header [lindex $args $i]
	    } -resultsvariable {
	        incr i
	        set vals($w,resultsvariable) [lindex $args $i]
	    } default {
	    	error "unrecognized arg [lindex $args $i]"
	    }
	}
	frame $w -class TheoremSaveBox
	if ![info exists header] { set header [option get $w header Header] }
	if ![info exists vals($w,resultsvariable)] { set vals($w,resultsvariable) [option get $w resultsvariable ResultsVariable] }

	pack [label $w.header \
		-text $header \
		-font $gui_flags(font,labels) ] \
	    -side top -padx 10 -pady 10
	    

	pack [frame $w.options -borderwidth 2 -relief sunken] -side top -pady 10
	pack [frame $w.options.save] -side top -pady 10 -padx 10
	pack [fontcheck entry $w.options.save.name \
		-font $gui_flags(font,textentry) \
		-relief sunken] \
	    -side right -expand yes -fill x

	pack [fontcheck focusable checkbutton $w.options.save.cb \
		-width 20 \
		-text "Save to theory as: " \
		-variable vals($w,save) \
		-font $gui_flags(font,buttons) \
		-relief flat \
		-anchor w] \
	    -side left -fill x
	set vals($w,save) 1
	pack [fontcheck focusable checkbutton $w.options.bind \
		-text "Bind to corresponding ML identifier" \
		-variable vals($w,bind) \
		-font $gui_flags(font,buttons) \
		-relief flat \
		-anchor w] \
	    -side left -fill x -expand yes -padx 10
	set vals($w,bind) 1
	pack [fontcheck focusable checkbutton $w.options.view_script \
		-text "View script" \
		-variable vals($w,view_script) \
		-font $gui_flags(font,buttons) \
		-relief flat \
		-anchor w] \
	    -side left -fill x -expand yes -padx 10
	set vals($w,view_script) 1
	pack [frame $w.controls] -side bottom -pady 10
	pack [fontcheck focusable button $w.controls.ok \
		-width 6 \
		-text Ok \
		-command "TheoremSaveBox::Ok $w" \
	 	-font $gui_flags(font,buttons)] \
	    -side left \
	    -padx 10
	pack [fontcheck focusable button $w.controls.cancel \
		-width 6 \
		-text Cancel \
		-command "set $vals($w,resultsvariable) Cancel" \
		-font $gui_flags(font,buttons)] \
	    -side left \
	    -padx 10
	wm protocol [winfo toplevel $w] WM_DELETE_WINDOW "set $vals($w,resultsvariable) Cancel"
	button_setDefault $w.controls.ok
	focus_goToFirst $w
	bind $w <Destroy> "unset_vals_for_widget $w"
}





proc TheoremSaveBox::Ok { w } {
	global vals
 	set savename [$w.options.save.name get]
	if {($vals($w,save) || $vals($w,bind)) && ![regexp {([A-Z]|[a-z])([A-Z]|[a-z]|[0-9]|_)*} $savename]} {
	    	errormessage $w.error "You must specify a valid ML identifier for the theorem name"
		return
	}
	upvar #0 $vals($w,resultsvariable) var
 	set var [list Ok $vals($w,save) $savename $vals($w,bind) $vals($w,view_script)]
}
