#############################################################################
#   TkDefineType.tcl,v 1.5 1995/04/04 16:39:06 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################



#----------------------------------------------------------------------------
#
# WIDGET CLASS TkDefineType
#
# CONFIGURATION OPTIONS
#
# COMMANDS
#
#----------------------------------------------------------------------------

option add *TkDefineType.withfeedback 1 widgetDefault

proc TkDefineType { w args } {
	global gui_flags 
	global TkDefineType_flags
	global feedback
	global busy
	incr busy
	global vals

	for {set i 0} {$i<[llength $args]} {incr i} {
	    case [lindex $args $i] default {
	    	error "unrecognized arg [lindex $args $i]"
	    }
	}

	toplevel $w -class TkDefineType

	if ![info exists withfeedback] { set withfeedback [option get $w withfeedback WithFeedback] }


	wm withdraw $w
	wm minsize $w 1 1
	wm title $w "New Type Definition"
	
	set feedback [list {} "Creating TkDefineType display..."]
	
	if {$withfeedback} {
	    fontcheck label $w.feedback \
		-height 1 \
		-width 40 \
		-anchor w \
		-relief sunken \
		-font $gui_flags(font,feedback)
	    pack $w.feedback -side bottom -expand no -fill x
	}

	pack [frame $w.controls -borderwidth 2] -side bottom
	pack [fontcheck focusable button $w.controls.define \
		-command "TkDefineType::define $w" \
		-text "Execute" \
		-width 11 \
		-font $gui_flags(font,buttons)] \
	    -side left -fill x -padx 10 -pady 10

	if [hol88] {
	    set helpcommand ""
	}
	if [hol90] {
	    set helpcommand "HolHelp::hol90_help syntax.html"
	}
	pack [fontcheck focusable button $w.controls.help \
		-command $helpcommand \
		-text "Help" \
		-width 11 \
		-font $gui_flags(font,buttons)] \
	    -side left -fill x -padx 10 -pady 10
	pack [fontcheck focusable button $w.controls.close \
		-command "destroy $w" \
		-text "Close" \
		-width 11 \
		-font $gui_flags(font,buttons)] \
	    -side left -fill x -padx 10 -pady 10
	

	pack [frame $w.options] -side bottom
	pack [frame $w.options.r] -side right -fill y
	pack [frame $w.options.l] -side left -fill y 
	
	
	pack [frame $w.options.l.basic -borderwidth 2 -relief sunken] -fill both -expand yes -padx 5 -pady 5
	pack [label $w.options.l.basic.label -text "Basic Options:" -anchor w -font $gui_flags(font,labels)] -side top -fill x
	foreach buttondef [list \
		[list define_type "Define Type"] \
		[list prove_induct "Prove Induction Theorem"] \
		[list prove_oneone "Prove Constructors 1-1"] \
		[list prove_distinct "Prove Constructors Distinct"] \
		[list prove_reversed_distinct "Prove Reversed Distinction Theorems also"] \
		[list prove_cases "Prove Cases Theorem"] \
	    ] {
	    pack [fontcheck focusable checkbutton $w.options.l.basic.[lindex $buttondef 0]\
		-variable vals($w,[lindex $buttondef 0]) \
		-text [lindex $buttondef 1] \
		-relief flat \
		-anchor w \
		-font $gui_flags(font,buttons)] \
	    -side top -fill x -padx 10
	    set vals($w,[lindex $buttondef 0]) 1
	}
	pack [frame $w.options.r.additional -borderwidth 2 -relief sunken] -side top -fill x  -padx 5 -pady 5
	pack [label $w.options.r.additional.label -text "Additional Options (not yet available):" -anchor w -font $gui_flags(font,labels)] -side top -fill x
	foreach buttondef [list \
		[list define_discriminators "Define selectors on variants"] \
		[list define_accessors "Define accessors on records"] \
		[list define_mutators "Define mutators on records"] \
		[list prove_mutators_commute "Prove mutators commute"] \
		[list define_ml_functions "Define ML syntax functions"] \
	    ] {
	    pack [fontcheck focusable checkbutton $w.options.r.additional.[lindex $buttondef 0]\
		    -variable vals($w,[lindex $buttondef 0]) \
		    -text [lindex $buttondef 1] \
		    -relief flat \
		    -anchor w \
		    -font $gui_flags(font,buttons)] \
	    	-side top -fill x -padx 10
	    $w.options.r.additional.[lindex $buttondef 0].b config -state disabled 
	    set vals($w,[lindex $buttondef 0]) 0
	}
	pack [frame $w.options.r.save -borderwidth 2 -relief sunken] -side bottom -fill x -padx 5 -pady 5
	pack [label $w.options.r.save.label -text "Save Options:" -anchor w -font $gui_flags(font,labels)] -side top -fill x
	foreach buttondef [list \
		[list save_thms "Save Theorems"] \
		[list view_thms "View Script"] \
	    ] {
	    pack [fontcheck focusable checkbutton $w.options.r.save.[lindex $buttondef 0]\
		-variable vals($w,[lindex $buttondef 0]) \
		-text [lindex $buttondef 1] \
		-relief flat \
		-anchor w \
		-font $gui_flags(font,buttons)] \
	    -side top -fill x -padx 10
	    set vals($w,[lindex $buttondef 0]) 1
	}
	
	frame $w.sources
	pack $w.sources -side top -fill both -expand yes -padx 5 -pady 5

	    #---------------
	
	pack [frame $w.typespec] -in $w.sources -side top -fill both -expand yes
	pack [fontcheck label $w.typespec.lab -font $gui_flags(font,labels) -text "Type Specification:" -anchor w] -side top -fill x
    	pack [fontcheck scrollable text $w.typespec.spec -relief sunken -font $gui_flags(font,codeentry) -borderwidth 2 -height 15 -width 60] -fill both -expand yes

	if [hol88] {
	    $w.typespec.spec.b insert 1.0 "btree = LEAF *\n       | NODE btree btree\n"
	}
	if [hol90] {
	    $w.typespec.spec.b insert 1.0 "btree = LEAF of 'a\n       | NODE of btree => btree\n"
	}
	bind $w <Destroy> "unset_vals_for_widget $w"

	update
	focus_goToFirst $w.controls
	button_setDefault $w.controls.define

	wm deiconify $w
	tkwait visibility $w

	incr busy -1
	return $w
}


#----------------------------------------------------------------------------
# TkDefineType::define
#
#----------------------------------------------------------------------------

proc TkDefineType::define { w  } {
	global feedback
	global busy
	global vals
	incr busy
	set spec [$w.typespec.spec.b get 1.0 end]
	scan $spec %s name
	set axiom_name [set name]_Axiom
	set induct_name [set name]_Induct
	set oneone_name [set name]_11
	set distinct_name [set name]_distinct
	set cases_name [set name]_cases

	if $vals($w,define_type) {
	# Now proceed to the fixities, which are needed for HOL90 only.
	    if [hol90] {
	        set mlcode "map (#constructor) (#clauses (Parse.type_spec_parser ([ml_frag_quote $spec])))"
	        if [catch {ML -type stringlist -check 1 $mlcode} constructors] {
	            errormessage $w.error $constructors; incr busy -1; return
                }
	        modalDialog transient SpecifyFixitiesBox $w.save \
	    		-header "Select the fixities for the constructors:" \
	    		-resultsvariable vals($w,waiter) \
	    		-constructors $constructors \
			-withfeedback 0
	        widget_waitVariable vals($w,waiter)
	        modalDialog.end $w.save
	        switch -- [lindex $vals($w,waiter) 0] Ok { 
	    	    set fixities [lrange $vals($w,waiter) 1 end]
	        } Cancel { 
	    	    incr busy -1;
	       	    return
	        }
	    }
	    set feedback [list $w "Defining the type..."]

	    if [hol88] {
		set defn "define_type \n\t[ml_string $axiom_name] \n[ml_string $spec]"
	    }
	    if [hol90] {
	        set defn "define_type {\n\tfixities=[ml_list $fixities], \n\tname=[ml_string $axiom_name], \n\ttype_spec= \n\n[ml_frag_quote [join [split $spec \n] \n\t]]\n}"
	    }
	    set script "[ml_val] $axiom_name = [join [split $defn \n] \n\t][ml_end_dec]"
	    lappend sections [list $axiom_name $defn $script]
        }

	if $vals($w,prove_induct) {
	    set defn "[hol_prove_induction_thm] $axiom_name"
	    if $vals($w,save_thms) {
	   	set defn "save_thm([ml_string $induct_name], \n\t\t$defn)"	
	    }
	    set script "[ml_val] $induct_name = [join [split $defn \n] \n\t][ml_end_dec]"
	    lappend sections [list $induct_name $defn $script]
        }

	if $vals($w,prove_oneone) {
	    set defn "[hol_prove_constructors_one_one] $axiom_name"
	    if $vals($w,save_thms) {
	   	set defn "save_thm([ml_string $oneone_name], \n\t$defn)"	
	    }
	    set script "[ml_val] $oneone_name = [join [split $defn \n] \n\t][ml_end_dec]"
	    lappend sections [list $oneone_name $defn $script]
        }

	if $vals($w,prove_distinct) {
	    if $vals($w,prove_reversed_distinct) {
		set defn "([ml_letval] thml = CONJUNCTS ([hol_prove_constructors_distinct] $axiom_name) \n[ml_letin] (LIST_CONJ (thml @ (map GSYM thml))) [ml_letend])"
	    } else {
		set defn "[hol_prove_constructors_distinct] $axiom_name"
	    }
	    if $vals($w,save_thms) {
	   	set defn "save_thm([ml_string $distinct_name], \n[join [split $defn \n] \n\t])"	
	    }
	    set script "[ml_val] $distinct_name = [join [split $defn \n] \n\t][ml_end_dec]"
	    lappend sections [list $distinct_name $defn $script]
        }

	if $vals($w,prove_cases) {
	    set defn "[hol_prove_cases_thm] $induct_name"
	    if $vals($w,save_thms) {
	   	set defn "save_thm([ml_string $cases_name], \n\t$defn)"	
	    }
	    set script "[ml_val] $cases_name = [join [split $defn \n] \n\t][ml_end_dec]"
	    lappend sections [list $cases_name $defn $script]
        }


	set total_script ""
	set thmspecs ""
	foreach section $sections {
	    set name [lindex $section 0]
	    set defn [lindex $section 1]
	    set script [lindex $section 2]
	    set feedback [list $w "Proving $name"]
	    if [catch {ML_bind $name $defn -check 1 -log 0} err] {
	        errormessage $w.error $err; incr busy -1; return
            }
	    lappend thmspecs [list $name {} {}]
	    ML -run 0 -toplevel 1 -log 1 $script
	    set total_script "[set total_script]\n\n$script"
	}
		   
	global gui_flags
	set newwin [newwin TheoremsTopLevel \
		-title {TkDefineType Results} \
		-header {Theorems Generated by TkDefineType:} \
		-thmspecs $thmspecs \
		-bindbuttons 0 \
		-expandbuttons 0 \
		-withtext 1 \
		-text $total_script]
	TheoremsFrame::expandall $newwin.thmspecs

	incr busy -1	

}



#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc tkntd { } {
   after 1 {
   	source $TkDefineType_library/TkDefineType.tcl
   	newwin TkDefineType
   }
}
