(*--------------------------------------------------------------       *)
(* theory_notify.sig,v 1.3 1995/04/04 16:39:00 drs1004 Exp	       *)
(* 								       *)
(* Provides a replacement set of `theory functions`, i.e.	       *)
(* save_thm, new_parent, close_theory, extend_theory and so on.	       *)
(*								       *)
(* Things in this file should be considered pretty volatile, but	*)
(* they will eventually settle down.					*)
(*									*)
(* My hope would be that this functionality will eventually be 		*)
(* incorporated into the base HOL systems.				*)
(*								       *)
(* The repacement functions are operationally equivalent, except       *)
(* that they will also `notify` other interested clients in the system *)
(* of the change that has occured in the theory =>  This can be used     *)
(* to mimic the changes in an interface, even if the operations are    *)
(* performed by a package external to the interface.		       *)
(*								       *)
(* CLIENTS							       *)
(*								       *)
(* There are two types of clients - ML and Tcl =>  		       *)
(*								       *)
(* ML clients are a group of ML functions each of which is called      *)
(* when appropriate =>  An ML client also has a			       *)
(* name (which should be unique amongst clients)		       *)
(* by which it may be removed.					       *)
(*								       *)
(* Tcl clients							       *)
(* are a special class of client which pass calls directly	       *)
(* through to tcl functions with particular names and argument	       *)
(* patterns =>  For instance, for each tcl client of the theory	       *)
(* the function							       *)
(*								       *)
(*	<tclclass>::new_theorem_Notify <tclobj> <theory> <thmname>     *)
(*								       *)
(* will be called each time a theorem is save to the theory =>  Here   *)
(* <tclclass> and <tclobj> are specified when creating the client =>   *)
(* <theory> is the theory to which the theorem was saved, and	       *)
(* <thmname> is the name of the theorem just saved.		       *)
(*								       *)
(* Tcl clients do not have to support all the notification messages    *)
(* (unlike ML clients), but they must indicate which ones they want    *)
(* to recieve.	 						       *)
(*								       *)
(*--------------------------------------------------------------       *)


signature TheoryNotification_sig = sig
	type client

	val add_client: string -> client -> unit
	val remove_client: string -> string -> unit
	val mk_client: 
		string * 				(* the theory being watched *)
		(string -> string -> thm -> unit) * 	(* called when a new theorem is added to theory *)
		(string -> string -> thm -> unit) * 	(* called when a new definition is added to theory *)
		(string -> string -> thm -> unit) *	(* called when a new axiom is added to theory *)
		(string -> term -> unit) *		(* called when a new constant is added to theory *)
		(string -> {Arity:int, Name:string} -> unit)		(* called when a new type is added to theory *)
		   -> client

	val define_type  : {fixities:fixity list, name:string, type_spec:term frag list} -> thm
	val new_definition : string * term -> thm
	val new_specification : {consts:{const_name:string, fixity:fixity} list, name:string, sat_thm:thm} -> thm
	val save_thm : string * thm -> thm
	val store_thm : string * term * tactic -> thm
	val most_general_wrapper : (unit -> 'a) -> 'a;
	
	val test : unit -> bool;
end

signature TclTheoryNotification_sig = sig
	type client
	type selection
	val on_new_thm: selection
	val on_new_definition: selection
	val on_new_axiom: selection
	val on_new_const: selection
	val on_new_type: selection
	
	val mk_client: string * string * (selection list) -> client
	val add_client: string -> client -> unit
	val remove_client: string -> client -> unit
end	






































