(*====================================================================
 *
 * structure HolTermPatterns
 *                                                                    
 * use "hol90_termpaths/src/termpatterns.sig";
 * use "hol90_termpaths/src/termpatterns.sml";
 * open HolTermPatterns;
(*
open HolTermPatterns;
PATT_REWRITE_TAC (-|`(P:bool) = _`|-) [] ([],(--`(1=1) = T`--));;
PATT_REWRITE_TAC (-|`(P:bool) = Q`|-) [] ([],(--`(1=1) = T`--));;
PATT_REWRITE_TAC (-|`(P:bool)`|-) [] ([],(--`(1=1) = T`--));;
PATT_REWRITE_TAC (-|`(n:num = _) = _`|-) [] ([],(--`(1=1) = T`--));;
*)

 *====================================================================*)
   
structure HolTermPatternTactics: HolTermPatternTactics_sig =
struct

   open HolTermPaths;
   open HolTermPathTactics;
   open HolTermPatterns;
   
   
   fun PATT_CONV pat c = 
      itlist (curry (op THENC))
	(map ((C PATH_CONV) c) (termpaths_of_pattern pat)) ALL_CONV
   fun PATT_CONV_TAC pat c = CONV_TAC (PATT_CONV pat c);
   fun PATT_REWRITE_TAC pat = (PATT_CONV_TAC pat) o REWRITE_CONV
   fun PURE_PATT_REWRITE_TAC pat = (PATT_CONV_TAC pat) o PURE_REWRITE_CONV
   fun ONCE_PATT_REWRITE_TAC pat = (PATT_CONV_TAC pat) o ONCE_REWRITE_CONV
   fun PURE_ONCE_PATT_REWRITE_TAC pat = (PATT_CONV_TAC pat) o PURE_ONCE_REWRITE_CONV
   
   fun GEN_ASM_REWRITE_TAC f pat thl =   
      ASSUM_LIST (fn asl => f pat (asl @ thl))
   val PURE_PATT_ASM_REWRITE_TAC = GEN_ASM_REWRITE_TAC PURE_PATT_REWRITE_TAC
   and PATT_ASM_REWRITE_TAC = GEN_ASM_REWRITE_TAC PATT_REWRITE_TAC
   and PURE_ONCE_PATT_ASM_REWRITE_TAC = GEN_ASM_REWRITE_TAC PURE_ONCE_PATT_REWRITE_TAC
   and ONCE_PATT_ASM_REWRITE_TAC = GEN_ASM_REWRITE_TAC ONCE_PATT_REWRITE_TAC
end;

