


structure SMLPP  =
struct

structure Const = SMLConstructors
and Dest = SMLDestructors
and Ext = SMLExternals
and StringTable = SMLStringTable;

structure PP =
struct

structure PPBoxes = PPBoxesFun (struct val char_size = 1000; end);

open PPBoxes;

fun pp s =
   let val (mapped_string,mapped_width) = StringTable.lookup s in
   pp_string_box (mapped_string,mapped_width)
   end;

end;

structure Local =
struct

open PrettySupport;

fun precedence "#appl" = 2000
  | precedence "if" = 400
  | precedence "fn" = 300
  | precedence "while" = 300
  | precedence "case" = 300
  | precedence "handle" = 200
  | precedence "raise" = 200
  | precedence ";" = 100
  | precedence ":" = 0
  | precedence s' = if Ext.is_infix s' then 1000 else 0;

fun attrib s att =
   let fun attrib s' =
          if Ext.is_infix s' then (fn _ => "") else (fn _ => "")
   in StringTable.attrib s att
      handle StringTable.StringTable => attrib s att
   end;

fun is s att =
   let fun is s' =
          if Ext.is_infix s' then (fn _ => false) else (fn _ => false)
   in StringTable.is s att handle StringTable.StringTable => is s att
   end;

val box_el = el PP.pp_empty_box;

fun lower_prec s = PREC (2 * precedence s - 1);

fun upper_prec s = PREC (2 * precedence s);

fun lpar prec s =
   if prec_test (prec,upper_prec s) then PP.pp "(" else PP.pp_empty_box;

fun rpar prec s =
   if prec_test (prec,upper_prec s) then PP.pp ")" else PP.pp_empty_box;

end;

val initial_precedence = Local.MINPREC;

val error = "";

val elision = " ... ";

val default_h = 0
and default_v = (PP.ABSOLUTE 0,0)
and default_hv = (0,PP.ABSOLUTE 0,0)
and default_hov = (0,PP.ABSOLUTE 0,0);

val initial_depth = ~1;

val initial_params = {context = ""};

structure D =
struct open Dest;

       val BINOP = fn tr => let val (tr1,tr2) = DAppExp tr
                                val tr11 = DVarExp tr1
                                val op' = tr11
                                val (tr21,tr22) = D2TupleExp tr2
                                val arg1' = tr21
                                val arg2' = tr22 in (op',arg1',arg2') end;

       val UNOP = fn tr => let val (tr1,tr2) = DAppExp tr
                               val tr11 = DVarExp tr1
                               val op' = tr11
                               val arg' = tr2 in (op',arg') end;

       open Dest; end;

local
   open Const
in

fun pp_int {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val i' = tr in PP.pp (Ext.int_to_string i') end
        handle _ => PP.pp error
and pp_real {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val r' = tr in PP.pp (Ext.real_to_string r') end
        handle _ => PP.pp error
and pp_bool {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val b' = tr in if b' then PP.pp "true" else PP.pp "false" end
        handle _ => PP.pp error
and pp_symbol {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val tr1 = D.DSymbol tr
            val s' = tr1 in PP.pp s' end handle _ => PP.pp error
and pp_path {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val tr1 = D.DPath tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val syms' = tr11
            val sym' = tr12
        in PP.pp_h_box 0
              (map (fn el =>
                       PP.pp_h_box 0
                          [Local.box_el
                              (pp_symbol {outer_prec = Local.MINPREC,
                                          depth = depth - 1}
                                  {context = context'}) syms' el,
                           PP.pp "."]) (Local.upto 1 (length syms')) @
               [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} sym'])
        end handle _ => PP.pp error
and pp_ruless {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val tr1 = D.DRules tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val ruless' = tr11
            val rule' = tr12
        in PP.pp_hov_box (1000,PP.ABSOLUTE 3000,1000)
              (map (fn el =>
                       PP.pp_h_box 1000
                          [Local.box_el
                              (pp_rule {outer_prec = Local.MINPREC,
                                        depth = depth - 1}
                                  {context = context'}) ruless' el,
                           PP.pp "|"]) (Local.upto 1 (length ruless')) @
               [pp_rule {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} rule'])
        end handle _ => PP.pp error
and pp_tyvar {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val tr1 = D.DTyv tr
            val sym' = tr1
        in pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
              {context = context'} sym'
        end handle _ => PP.pp error
and pp_ty {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val tr1 = D.DVarTy tr
            val tyvar' = tr1
        in pp_tyvar {outer_prec = Local.MINPREC,depth = depth - 1}
              {context = context'} tyvar'
        end handle _ =>
            let val (tr1,tr2) = D.DConTy tr
                val path' = tr1
                val tys' = tr2
            in PP.pp_h_box 1000
                  (map (fn el => PP.pp_h_box 0
                                    [Local.box_el
                                        (pp_ty {outer_prec = Local.MINPREC,
                                                depth = depth - 1}
                                            {context = context'}) tys' el])
                      (Local.upto 1 (length tys')) @
                   [pp_path {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} path'])
            end handle _ => PP.pp error
and pp_exp {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val tr1 = D.DFragList tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val elem' = tr11
            val elems' = tr12
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "`",
               PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                  ([PP.pp "`"] @
                   [pp_frag
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} elem'] @
                   map
                      (fn el =>
                          PP.pp_h_box 0
                             [Local.box_el
                                 (pp_frag
                                     {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                                     {context = context'}) elems' el])
                      (Local.upto 1 (length elems')) @ [PP.pp "`"]),
               Local.rpar outer_prec "`"]
        end
        handle _ =>
        let val _ = D.DNil tr in PP.pp "[]" end
        handle _ =>
        let val tr1 = D.DList tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val elems' = tr11
            val elem' = tr12
        in PP.pp_hv_box (0,PP.ABSOLUTE 0,1000)
              ([PP.pp "["] @
               map (fn el => PP.pp_h_box 0
                                [Local.box_el
                                    (pp_exp {outer_prec = Local.MINPREC,
                                             depth = depth - 1}
                                        {context = context'}) elems' el,
                                 PP.pp ","])
                  (Local.upto 1 (length elems')) @
               [pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} elem',PP.pp "]"])
        end
        handle _ =>
        let val (tr1,tr2) = D.DAppExp tr
            val (tr11,tr12) = D.DAppExp tr1
            val tr111 = D.DVarExp tr11
            val tr1111 = D.last tr111
            val tr11111 = D.DSymbol tr1111
            val op' = tr11111
            val tr121 = D.DFragList tr12
            val elems' = tr121
            val arg2' = tr2
            val _ = if Ext.is_parser op' then () else raise Local.PPpattern
        in PP.pp_h_box 0
              [Local.lpar outer_prec op',PP.pp op',
               PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                  ([PP.pp "`"] @
                   map
                      (fn el =>
                          PP.pp_h_box 0
                             [Local.box_el
                                 (pp_frag
                                     {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                                     {context = context'}) elems' el])
                      (Local.upto 1 (length elems')) @ [PP.pp "`"]),
               pp_exp
                  {outer_prec = Local.upper_prec op',depth = depth - 1}
                  {context = context'} arg2',Local.rpar outer_prec op']
        end
        handle _ =>
        let fun loop_1 n result =
               let val tr = #tr result
                   val (tr1,tr2,tr3) = D.BINOP tr
                   val tr11 = D.last tr1
                   val tr111 = D.DSymbol tr11
                   val op' = tr111
                   val args' = tr2
                   val link = tr3
               in if (case #op' result of NONE => true | SOME x => op' = x)
                  then loop_1 (n + 1)
                          {op' = SOME op',args' = #args' result @ [args'],
                           tr = link}
                  else raise Local.PPpattern
               end handle e => if n >= 1 then result else raise e
            val (op',args',tr1) =
               case loop_1 0 {op' = NONE,args' = [],tr = tr}
               of {op' = SOME op',args',tr = tr1} => (op',args',tr1)
                | _ => raise Local.PPpattern
            val arg' = tr1
            val _ = if Ext.is_infix op' then () else raise Local.PPpattern
        in PP.pp_h_box default_h
              [Local.lpar outer_prec op',
               PP.pp_hv_box (1000,PP.ABSOLUTE 0,0)
                  (map (fn el =>
                           PP.pp_hv_box (1000,PP.ABSOLUTE 0,0)
                              [Local.box_el
                                  (pp_exp {outer_prec =
                                              Local.upper_prec op',
                                           depth = depth - 1}
                                      {context = context'}) args' el,
                               PP.pp op'])
                      (Local.upto 1 (length args')) @
                   [pp_exp {outer_prec = Local.upper_prec op',
                            depth = depth - 1} {context = context'}
                       arg']),Local.rpar outer_prec op']
        end
        handle _ =>
        let val tr1 = D.DIntExp tr
            val i' = tr1
        in pp_int {outer_prec = Local.MINPREC,depth = depth - 1}
              {context = context'} i'
        end
        handle _ =>
        let val tr1 = D.DRealExp tr
            val r' = tr1 in PP.pp r' end
        handle _ =>
        let val tr1 = D.DStringExp tr
            val s' = tr1
        in PP.pp_h_box 0 [PP.pp "\"",PP.pp s',PP.pp "\""]
        end
        handle _ =>
        let val tr1 = D.DRecordExp tr
            val _ = if null tr1 then () else raise Local.PPpattern
        in PP.pp "{}"
        end
        handle _ =>
        let val tr1 = D.DVarExp tr
            val path' = tr1
        in pp_path {outer_prec = Local.MINPREC,depth = depth - 1}
              {context = context'} path'
        end
        handle _ =>
        let val tr1 = D.DFnExp tr
            val ruless' = tr1
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "fn",
               PP.pp_hv_box (1000,PP.ABSOLUTE 2000,1000)
                  [PP.pp "fn",
                   pp_ruless
                      {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} ruless'],
               Local.rpar outer_prec "fn"]
        end
        handle _ =>
        let fun loop_1 n result =
               let val tr = #tr result
                   val (tr1,tr2) = D.DAppExp tr
                   val link = tr1
                   val arguments' = tr2
               in loop_1 (n + 1)
                     {arguments' = #arguments' result @ [arguments'],
                      tr = link}
               end handle e => if n >= 1 then result else raise e
            val {arguments',tr = tr1} = loop_1 0 {arguments' = [],tr = tr}
            val function' = tr1
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "#appl",
               PP.pp_hov_box (1000,PP.ABSOLUTE 3000,1000)
                  ([pp_exp {outer_prec = Local.upper_prec "#appl",
                            depth = depth - 1} {context = context'}
                       function'] @
                   map (fn el =>
                           Local.box_el
                              (pp_exp {outer_prec =
                                          Local.upper_prec "#appl",
                                       depth = depth - 1}
                                  {context = context'}) (rev arguments')
                              el) (Local.upto 1 (length arguments'))),
               Local.rpar outer_prec "#appl"]
        end
        handle _ =>
        let val (tr1,tr2) = D.DCaseExp tr
            val expr' = tr1
            val ruless' = tr2
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "case",
               PP.pp_hov_box (1000,PP.ABSOLUTE 2000,1000)
                  [PP.pp_h_box 1000
                      [PP.pp "case",
                       pp_exp {outer_prec = Local.MINPREC,
                               depth = depth - 1}
                          {context = context'} expr',PP.pp "of"],
                   pp_ruless
                      {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} ruless'],
               Local.rpar outer_prec "case"]
        end
        handle _ =>
        let val (tr1,tr2) = D.DLetExp tr
            val dec' = tr1
            val expr' = tr2
        in PP.pp_hov_sepbox (PP.pp "let")
              [((1000,PP.ABSOLUTE 3000,1000),
                pp_dec {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} dec'),
               ((1000,PP.ABSOLUTE 0,1000),PP.pp "in"),
               ((1000,PP.ABSOLUTE 3000,1000),
                pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} expr'),
               ((1000,PP.ABSOLUTE 0,1000),PP.pp "end")]
        end
        handle _ =>
        let val tr1 = D.DSeqExp tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val exprs' = tr11
            val expr' = tr12
        in PP.pp_h_box default_h
              [Local.lpar outer_prec ";",
               PP.pp_hv_box (1000,PP.ABSOLUTE 3000,0)
                  (map (fn el =>
                           PP.pp_h_box 0
                              [Local.box_el
                                  (pp_exp {outer_prec =
                                              Local.upper_prec ";",
                                           depth = depth - 1}
                                      {context = context'}) exprs'
                                  el,PP.pp ";"])
                      (Local.upto 1 (length exprs')) @
                   [pp_exp {outer_prec = Local.upper_prec ";",
                            depth = depth - 1} {context = context'}
                       expr']),Local.rpar outer_prec ";"]
        end
        handle _ =>
        let val tr1 = D.DRecordExp tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val symexps' = tr11
            val symexp' = tr12
        in let val boxes =
                  [((1000,PP.ABSOLUTE 3000,0),PP.pp "{")] @
                  map (fn el =>
                          ((1000,PP.ABSOLUTE 3000,0),
                           PP.pp_h_box 0
                              [Local.box_el
                                  (pp_symexp
                                      {outer_prec = Local.MINPREC,
                                       depth = depth - 1}
                                      {context = context'}) symexps'
                                  el,PP.pp ","]))
                     (Local.upto 1 (length symexps')) @
                  [((1000,PP.ABSOLUTE 3000,0),
                    PP.pp_h_box 0
                       [pp_symexp {outer_prec = Local.MINPREC,
                                   depth = depth - 1}
                           {context = context'} symexp']),
                   ((1000,PP.ABSOLUTE 0,0),PP.pp "}")]
           in PP.pp_hov_sepbox (#2 (hd boxes)) (tl boxes)
           end
        end
        handle _ =>
        let val tr1 = D.DTupleExp tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val exps' = tr11
            val exp' = tr12
        in PP.pp_h_box default_h
              [Local.lpar outer_prec ",",
               PP.pp_hov_box (1000,PP.ABSOLUTE 0,0)
                  (map (fn el =>
                           PP.pp_h_box 0
                              [Local.box_el
                                  (pp_exp {outer_prec =
                                              Local.upper_prec ",",
                                           depth = depth - 1}
                                      {context = context'}) exps' el,
                               PP.pp ","])
                      (Local.upto 1 (length exps')) @
                   [pp_exp {outer_prec = Local.upper_prec ",",
                            depth = depth - 1} {context = context'}
                       exp']),Local.rpar outer_prec ","]
        end
        handle _ =>
        let val tr1 = D.DSelectorExp tr
            val sym' = tr1
        in PP.pp_h_box 0
              [PP.pp "#",
               pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} sym']
        end
        handle _ =>
        let val (tr1,tr2) = D.DConstraintExp tr
            val expr' = tr1
            val constraint' = tr2
        in PP.pp_h_box default_h
              [Local.lpar outer_prec ":",
               PP.pp_h_box 0
                  [pp_exp
                      {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} expr',PP.pp ":",
                   pp_ty {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} constraint'],
               Local.rpar outer_prec ":"]
        end
        handle _ =>
        let val (tr1,tr2) = D.DHandleExp tr
            val expr' = tr1
            val ruless' = tr2
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "handle",
               PP.pp_hov_box (1000,PP.ABSOLUTE 3000,1000)
                  [pp_exp
                      {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} expr',PP.pp "handle",
                   pp_ruless
                      {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} ruless'],
               Local.rpar outer_prec "handle"]
        end
        handle _ =>
        let val tr1 = D.DRaiseExp tr
            val exp' = tr1
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "raise",
               PP.pp_h_box 1000
                  [PP.pp "raise",
                   pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} exp'],
               Local.rpar outer_prec "raise"]
        end
        handle _ =>
        let val (tr1,tr2,tr3) = D.DIfExp tr
            val test' = tr1
            val thencase' = tr2
            val elsecase' = tr3
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "if",
               PP.pp_hov_box (1000,PP.ABSOLUTE 0,1000)
                  [PP.pp_h_box 1000
                      [PP.pp "if",
                       pp_exp {outer_prec = Local.MINPREC,
                               depth = depth - 1} {context = context'}
                          test'],
                   PP.pp_h_box 1000
                      [PP.pp "then",
                       pp_exp {outer_prec = Local.MINPREC,
                               depth = depth - 1} {context = context'}
                          thencase'],
                   PP.pp_h_box 1000
                      [PP.pp "else",
                       pp_exp {outer_prec = Local.MINPREC,
                               depth = depth - 1} {context = context'}
                          elsecase']],Local.rpar outer_prec "if"]
        end
        handle _ =>
        let val (tr1,tr2) = D.DAndalsoExp tr
            val l' = tr1
            val r' = tr2
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "andalso",
               PP.pp_hv_box (0,PP.ABSOLUTE 0,1000)
                  [pp_exp
                      {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} l',PP.pp "andalso",
                   pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} r'],
               Local.rpar outer_prec "andalso"]
        end
        handle _ =>
        let val (tr1,tr2) = D.DOrelseExp tr
            val l' = tr1
            val r' = tr2
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "orelse",
               PP.pp_hv_box (0,PP.ABSOLUTE 0,1000)
                  [pp_exp
                      {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} l',PP.pp "orelse",
                   pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} r'],
               Local.rpar outer_prec "orelse"]
        end handle _ =>
            let val (tr1,tr2) = D.DWhileExp tr
                val test' = tr1
                val expr' = tr2
            in PP.pp_h_box default_h
                  [Local.lpar outer_prec "while",
                   PP.pp_hov_box (1000,PP.ABSOLUTE 0,1000)
                      [PP.pp_h_box 1000
                          [PP.pp "while",
                           pp_exp {outer_prec = Local.upper_prec "while",
                                   depth = depth - 1} {context = context'}
                              test'],
                       PP.pp_h_box 1000
                          [PP.pp "do",
                           pp_exp {outer_prec = Local.upper_prec "while",
                                   depth = depth - 1} {context = context'}
                              expr']],Local.rpar outer_prec "while"]
            end handle _ => PP.pp error
and pp_symexp {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2) = D.DSymExp tr
            val sym' = tr1
            val exp' = tr2
        in PP.pp_h_box 0
              [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} sym',PP.pp " = ",
               pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} exp']
        end handle _ => PP.pp error
and pp_frag {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val tr1 = D.DQuote tr
            val tr11 = D.DStringExp tr1
            val s' = tr11 in PP.pp s' end
        handle _ =>
        let val tr1 = D.DAntiquote tr
            val exp' = tr1
        in PP.pp_h_box 0
              [PP.pp "^(",
               pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} exp',PP.pp ")"]
        end handle _ => PP.pp error
and pp_rule {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2) = D.DRule tr
            val pat' = tr1
            val exp' = tr2
        in PP.pp_hov_box (1000,PP.ABSOLUTE 3000,1000)
              [pp_pat {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} pat',PP.pp "=>",
               pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} exp']
        end handle _ => PP.pp error
and pp_pat {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val _ = D.DWildPat tr in PP.pp "_" end
        handle _ =>
        let val tr1 = D.DVarPat tr
            val path' = tr1
        in pp_path {outer_prec = Local.MINPREC,depth = depth - 1}
              {context = context'} path'
        end
        handle _ =>
        let val tr1 = D.DIntPat tr
            val i' = tr1
        in pp_int {outer_prec = Local.MINPREC,depth = depth - 1}
              {context = context'} i'
        end
        handle _ =>
        let val tr1 = D.DRealPat tr
            val r' = tr1 in PP.pp r' end
        handle _ =>
        let val tr1 = D.DStringPat tr
            val s' = tr1 in PP.pp s' end
        handle _ =>
        let val (tr1,tr2) = D.DRecordPat tr
            val _ = if null tr1 then () else raise Local.PPpattern
            val flexibility' = tr2 in PP.pp "{}" end
        handle _ =>
        let val (tr1,tr2) = D.DRecordPat tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val sympats' = tr11
            val sympat' = tr12
            val flexibility' = tr2
        in let val boxes =
                  [((1000,PP.ABSOLUTE 3000,0),PP.pp "{")] @
                  map (fn el =>
                          ((1000,PP.ABSOLUTE 3000,0),
                           PP.pp_h_box 0
                              [Local.box_el
                                  (pp_sympat
                                      {outer_prec = Local.MINPREC,
                                       depth = depth - 1}
                                      {context = context'}) sympats'
                                  el,PP.pp ","]))
                     (Local.upto 1 (length sympats')) @
                  map (fn el =>
                          ((1000,PP.ABSOLUTE 3000,0),
                           Local.box_el
                              (pp_sympat {outer_prec = Local.MINPREC,
                                          depth = depth - 1}
                                  {context = context'}) sympats' el))
                     (Local.upto 1 (length sympats')) @
                  [((1000,PP.ABSOLUTE 0,0),PP.pp "}")]
           in PP.pp_hv_sepbox (#2 (hd boxes)) (tl boxes)
           end
        end
        handle _ =>
        let val tr1 = D.DTuplePat tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val pats' = tr11
            val pat' = tr12
        in let val boxes =
                  [((1000,PP.ABSOLUTE 3000,0),PP.pp "(")] @
                  map (fn el =>
                          ((1000,PP.ABSOLUTE 3000,0),
                           PP.pp_h_box 0
                              [Local.box_el
                                  (pp_pat
                                      {outer_prec = Local.MINPREC,
                                       depth = depth - 1}
                                      {context = context'}) pats' el,
                               PP.pp ","])) (Local.upto 1 (length pats')) @
                  [((1000,PP.ABSOLUTE 3000,0),
                    pp_pat
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} pat'),
                   ((1000,PP.ABSOLUTE 0,1000),PP.pp ")")]
           in PP.pp_hov_sepbox (#2 (hd boxes)) (tl boxes)
           end
        end
        handle _ =>
        let val (tr1,tr2) = D.DAppPat tr
            val constr' = tr1
            val argument' = tr2
        in PP.pp_h_box default_h
              [Local.lpar outer_prec "#appl",
               PP.pp_hov_box (1000,PP.ABSOLUTE 3000,1000)
                  [pp_path {outer_prec = Local.upper_prec "#appl",
                            depth = depth - 1} {context = context'}
                      constr',
                   pp_pat {outer_prec = Local.upper_prec "#appl",
                           depth = depth - 1} {context = context'}
                      argument'],Local.rpar outer_prec "#appl"]
        end handle _ =>
            let val (tr1,tr2) = D.DConstraintPat tr
                val pattern' = tr1
                val constraint' = tr2
            in PP.pp_h_box 0
                  [pp_pat {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} pattern',PP.pp ":",
                   pp_ty {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} constraint']
            end handle _ => PP.pp error
and pp_sympat {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2) = D.DSymPat tr
            val sym' = tr1
            val pat' = tr2
        in PP.pp_h_box 0
              [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} sym',PP.pp ":",
               pp_pat {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} pat']
        end handle _ => PP.pp error
and pp_dec {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val tr1 = D.DValDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val vb' = tr11
            val vbs' = tr12
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              ([PP.pp_h_box 1000
                   [PP.pp "val",
                    pp_vb
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} vb']] @
               map (fn el => PP.pp_h_box 1000
                                [PP.pp "and",
                                 Local.box_el
                                    (pp_vb {outer_prec = Local.MINPREC,
                                            depth = depth - 1}
                                        {context = context'}) vbs' el])
                  (Local.upto 1 (length vbs')))
        end
        handle _ =>
        let val tr1 = D.DValrecDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val rvb' = tr11
            val rvbs' = tr12
        in PP.pp_h_box 1000
              [PP.pp "rec",
               PP.pp_v_box (PP.ABSOLUTE 0,0)
                  ([PP.pp_h_box 1000
                       [PP.pp "rec val",
                        pp_rvb {outer_prec = Local.MINPREC,
                                depth = depth - 1}
                           {context = context'} rvb']] @
                   map (fn el =>
                           PP.pp_h_box 1000
                              [PP.pp "and",
                               Local.box_el
                                  (pp_rvb {outer_prec = Local.MINPREC,
                                           depth = depth - 1}
                                      {context = context'}) rvbs' el])
                      (Local.upto 1 (length rvbs')))]
        end
        handle _ =>
        let val tr1 = D.DFunDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val fb' = tr11
            val fbs' = tr12
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              ([PP.pp_h_box 1000
                   [PP.pp "fun",
                    pp_fb
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} fb']] @
               map (fn el => PP.pp_h_box 1000
                                [PP.pp "and",
                                 Local.box_el
                                    (pp_fb {outer_prec = Local.MINPREC,
                                            depth = depth - 1}
                                        {context = context'}) fbs' el])
                  (Local.upto 1 (length fbs')))
        end
        handle _ =>
        let val tr1 = D.DTypeDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val tb' = tr11
            val tbs' = tr12
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              ([PP.pp_h_box 1000
                   [PP.pp "type",
                    pp_tb
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} tb']] @
               map (fn el => PP.pp_h_box 1000
                                [PP.pp "and",
                                 Local.box_el
                                    (pp_tb {outer_prec = Local.MINPREC,
                                            depth = depth - 1}
                                        {context = context'}) tbs' el])
                  (Local.upto 1 (length tbs')))
        end
        handle _ =>
        let val (tr1,tr2) = D.DDatatypeDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val datatyc' = tr11
            val datatycs' = tr12
            val _ = if null tr2 then () else raise Local.PPpattern
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              ([PP.pp_h_box 1000
                   [PP.pp "datatype",
                    pp_db
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} datatyc']] @
               map (fn el =>
                       PP.pp_h_box 1000
                          [PP.pp "and",
                           Local.box_el
                              (pp_db {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                                  {context = context'}) datatycs' el])
                  (Local.upto 1 (length datatycs')))
        end
        handle _ =>
        let val (tr1,tr2) = D.DDatatypeDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val datatyc' = tr11
            val datatycs' = tr12
            val tr21 = hd tr2
            and tr22 = tl tr2
            val withtyc' = tr21
            val withtycs' = tr22
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              ([PP.pp_h_box 1000
                   [PP.pp "datatype",
                    pp_db
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} datatyc']] @
               map (fn el =>
                       PP.pp_h_box 1000
                          [PP.pp "and",
                           Local.box_el
                              (pp_db {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                                  {context = context'}) datatycs' el])
                  (Local.upto 1 (length datatycs')) @
               [PP.pp_h_box 1000
                   [PP.pp "with ",
                    pp_tb
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} withtyc']] @
               map (fn el =>
                       PP.pp_h_box 1000
                          [PP.pp "and",
                           Local.box_el
                              (pp_tb {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                                  {context = context'}) withtycs' el])
                  (Local.upto 1 (length withtycs')))
        end
        handle _ =>
        let val (tr1,tr2,tr3) = D.DAbstypeDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val abstyc' = tr11
            val abstycs' = tr12
            val _ = if null tr2 then () else raise Local.PPpattern
            val body' = tr3
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              ([PP.pp_h_box 1000
                   [PP.pp "abstype",
                    pp_db
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} abstyc']] @
               map (fn el =>
                       PP.pp_h_box 1000
                          [PP.pp "and",
                           Local.box_el
                              (pp_db {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                                  {context = context'}) abstycs' el])
                  (Local.upto 1 (length abstycs')) @
               [PP.pp_h_box 1000
                   [PP.pp "with",
                    pp_dec
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} body']])
        end
        handle _ =>
        let val (tr1,tr2,tr3) = D.DAbstypeDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val abstyc' = tr11
            val abstycs' = tr12
            val tr21 = hd tr2
            and tr22 = tl tr2
            val withtyc' = tr21
            val withtycs' = tr22
            val body' = tr3
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              ([PP.pp_h_box 1000
                   [PP.pp "abstype",
                    pp_db
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} abstyc']] @
               map (fn el =>
                       PP.pp_h_box 1000
                          [PP.pp "and",
                           Local.box_el
                              (pp_db {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                                  {context = context'}) abstycs' el])
                  (Local.upto 1 (length abstycs')) @
               [PP.pp_h_box 1000
                   [PP.pp "withtype",
                    pp_tb
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} withtyc']] @
               map (fn el =>
                       PP.pp_h_box 1000
                          [PP.pp "and",
                           Local.box_el
                              (pp_tb {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                                  {context = context'}) withtycs' el])
                  (Local.upto 1 (length withtycs')) @
               [PP.pp_h_box 1000
                   [PP.pp "with",
                    pp_dec
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} body']])
        end
        handle _ =>
        let val tr1 = D.DExceptionDec tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val eb' = tr11
            val ebs' = tr12
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              ([PP.pp_h_box 1000
                   [PP.pp "exception",
                    pp_eb
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} eb']] @
               map (fn el => PP.pp_h_box 1000
                                [PP.pp "and",
                                 Local.box_el
                                    (pp_eb {outer_prec = Local.MINPREC,
                                            depth = depth - 1}
                                        {context = context'}) ebs' el])
                  (Local.upto 1 (length ebs')))
        end
        handle _ =>
        let val (tr1,tr2) = D.DLocalDec tr
            val dec1' = tr1
            val dec2' = tr2
        in PP.pp_hov_sepbox (PP.pp "local")
              [((1000,PP.ABSOLUTE 3000,1000),
                pp_dec {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} dec1'),
               ((1000,PP.ABSOLUTE 0,1000),PP.pp "in"),
               ((1000,PP.ABSOLUTE 3000,1000),
                pp_dec {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} dec2'),
               ((1000,PP.ABSOLUTE 0,1000),PP.pp "end")]
        end
        handle _ =>
        let val tr1 = D.DSeqDec tr
            val tr1rev = rev tr1
            val tr11 = rev (tl tr1rev)
            and tr12 = hd tr1rev
            val decs' = tr11
            val dec' = tr12
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              (map (fn el => PP.pp_h_box 1000
                                [Local.box_el
                                    (pp_dec {outer_prec = Local.MINPREC,
                                             depth = depth - 1}
                                        {context = context'}) decs' el,
                                 PP.pp ";"])
                  (Local.upto 1 (length decs')) @
               [pp_dec {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} dec'])
        end
        handle _ =>
        let val tr1 = D.DOpenDec tr
            val syms' = tr1
        in PP.pp_h_box 1000
              ([PP.pp "open"] @
               map (fn el => PP.pp_h_box 1000
                                [Local.box_el
                                    (pp_path {outer_prec = Local.MINPREC,
                                              depth = depth - 1}
                                        {context = context'}) syms' el])
                  (Local.upto 1 (length syms')))
        end handle _ => PP.pp error
and pp_vb {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2) = D.DVb tr
            val pat' = tr1
            val exp' = tr2
        in PP.pp_h_box 1000
              [pp_pat {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} pat',PP.pp "=",
               pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} exp']
        end handle _ => PP.pp error
and pp_rvb {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2,tr3) = D.DRvb tr
            val var' = tr1
            val exp' = tr2
            val resultty' = tr3
        in PP.pp_h_box 1000
              [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} var',PP.pp "=",
               pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} exp']
        end handle _ => PP.pp error
and pp_fb {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2) = D.DFb tr
            val val' = tr1
            val tr2rev = rev tr2
            val tr21 = rev (tl tr2rev)
            and tr22 = hd tr2rev
            val clauses' = tr21
            val clause' = tr22
        in PP.pp_v_box (PP.ABSOLUTE 0,0)
              (map (fn el =>
                       PP.pp_h_box 1000
                          [pp_symbol {outer_prec = Local.MINPREC,
                                      depth = depth - 1}
                              {context = context'} val',
                           Local.box_el
                              (pp_clause {outer_prec = Local.MINPREC,
                                          depth = depth - 1}
                                  {context = context'}) clauses' el,
                           PP.pp "|"]) (Local.upto 1 (length clauses')) @
               [PP.pp_h_box 1000
                   [pp_symbol
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} val',
                    pp_clause
                       {outer_prec = Local.MINPREC,depth = depth - 1}
                       {context = context'} clause']])
        end handle _ => PP.pp error
and pp_clause {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2,tr3) = D.DClause tr
            val pats' = tr1
            val resultty' = tr2
            val exp' = tr3
        in PP.pp_h_box 1000
              (map (fn el => PP.pp_hov_box (0,PP.ABSOLUTE 0,1000)
                                [Local.box_el
                                    (pp_pat {outer_prec = Local.MINPREC,
                                             depth = depth - 1}
                                        {context = context'}) pats' el])
                  (Local.upto 1 (length pats')) @
               [PP.pp "=",
                pp_exp {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} exp'])
        end handle _ => PP.pp error
and pp_tb {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2,tr3) = D.DTb tr
            val tyc' = tr1
            val def' = tr2
            val tyvs' = tr3
        in PP.pp_h_box 1000
              ([PP.pp "type"] @
               map (fn el =>
                       PP.pp_h_box default_h
                          [Local.box_el
                              (pp_tyvar {outer_prec = Local.MINPREC,
                                         depth = depth - 1}
                                  {context = context'}) tyvs' el])
                  (Local.upto 1 (length tyvs')) @
               [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} tyc',PP.pp "=",
                pp_ty {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} def'])
        end handle _ => PP.pp error
and pp_db {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2,tr3) = D.DDb tr
            val tyc' = tr1
            val tyvs' = tr2
            val tr31 = hd tr3
            and tr32 = tl tr3
            val def' = tr31
            val defs' = tr32
        in PP.pp_h_box 1000
              ([PP.pp "datatype"] @
               map (fn el =>
                       PP.pp_h_box default_h
                          [Local.box_el
                              (pp_tyvar {outer_prec = Local.MINPREC,
                                         depth = depth - 1}
                                  {context = context'}) tyvs' el])
                  (Local.upto 1 (length tyvs')) @
               [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                   {context = context'} tyc',PP.pp "=",
                PP.pp_hov_box (0,PP.ABSOLUTE 0,1000)
                   ([pp_def {outer_prec = Local.MINPREC,
                             depth = depth - 1} {context = context'}
                        def'] @
                    map (fn el =>
                            PP.pp_h_box 1000
                               [PP.pp "|",
                                Local.box_el
                                   (pp_def
                                       {outer_prec = Local.MINPREC,
                                        depth = depth - 1}
                                       {context = context'}) defs' el])
                       (Local.upto 1 (length defs')))])
        end handle _ => PP.pp error
and pp_def {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2) = D.DDbDef tr
            val symbol' = tr1
            val tr21 = D.DSOME tr2
            val ty' = tr21
        in PP.pp_h_box 1000
              [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} symbol',
               pp_ty {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} ty']
        end handle _ =>
            let val (tr1,tr2) = D.DDbDef tr
                val symbol' = tr1
                val _ = D.DNONE tr2
            in PP.pp_h_box 1000
                  [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} symbol']
            end handle _ => PP.pp error
and pp_eb {outer_prec,depth} {context = context'} tr =
   if depth = 0
   then PP.pp elision
   else let val (tr1,tr2) = D.DEbGen tr
            val exn' = tr1
            val tr21 = D.DSOME tr2
            val etype' = tr21
        in PP.pp_h_box 1000
              [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} exn',
               pp_ty {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} etype']
        end
        handle _ =>
        let val (tr1,tr2) = D.DEbGen tr
            val exn' = tr1
            val _ = D.DNONE tr2
        in PP.pp_h_box 1000
              [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                  {context = context'} exn']
        end handle _ =>
            let val (tr1,tr2) = D.DEbDef tr
                val exn' = tr1
                val edef' = tr2
            in PP.pp_h_box 1000
                  [pp_symbol {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} exn',
                   pp_path {outer_prec = Local.MINPREC,depth = depth - 1}
                      {context = context'} edef']
            end handle _ => PP.pp error;

end;

val print_int =
   pp_int {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_real =
   pp_real {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_bool =
   pp_bool {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_symbol =
   pp_symbol {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_path =
   pp_path {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_ruless =
   pp_ruless {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_tyvar =
   pp_tyvar {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_ty = pp_ty {outer_prec = initial_precedence,depth = initial_depth}
                  initial_params;

val print_exp =
   pp_exp {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_symexp =
   pp_symexp {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_frag =
   pp_frag {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_rule =
   pp_rule {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_pat =
   pp_pat {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_sympat =
   pp_sympat {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_dec =
   pp_dec {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_vb = pp_vb {outer_prec = initial_precedence,depth = initial_depth}
                  initial_params;

val print_rvb =
   pp_rvb {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_fb = pp_fb {outer_prec = initial_precedence,depth = initial_depth}
                  initial_params;

val print_clause =
   pp_clause {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_tb = pp_tb {outer_prec = initial_precedence,depth = initial_depth}
                  initial_params;

val print_db = pp_db {outer_prec = initial_precedence,depth = initial_depth}
                  initial_params;

val print_def =
   pp_def {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_eb = pp_eb {outer_prec = initial_precedence,depth = initial_depth}
                  initial_params;

end;
