(****************************************************************************)
(*                                                                          *)
(*               Copyright 1994, 1995 University of Cambridge               *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(* plaintext.sml,v 1.2 1995/05/01 13:33:14 drs1004 Exp                                                                     *)
(* DESCRIPTION   : Support code for HOL pretty-printer.                     *)
(* AUTHOR        : R.J.Boulton/Donald Syme                                  *)
(*                                                                          *)
(****************************************************************************)

(*
 prim_load_library Lib.interpret {lib=find_library "plaintext",theory="-"};;
 use "hol90_plaintext/src/plaintext.sig";
 use "hol90_plaintext/src/plaintext.sml";
*)



(*--------------------------------------------------------------------------                                                                          
 * term_to_string
 * type_to_string
 * goal_to_string
 * thm_to_string
 *                                                                          
 * term_to_string (--`let x = 1 in x`--);;
 * term_to_string (concl (theorem "arithmetic" "ADD_CLAUSES"));;
 * map (term_to_string o concl o snd) (theorems "arithmetic");;
 * 									    
 * load_library {lib=find_library "plaintext",theory="-"};;
 *--------------------------------------------------------------------------*)

structure Plaintext: Plaintext_sig =
struct

fun type_to_string {output_width} ty = 
    Hol_pp.type_to_string ty;

fun term_to_string {output_width,show_types} tm = 
    let val old_show_types = (!Globals.show_types) 
        val _ = (Globals.show_types := show_types)
        val res = Hol_pp.term_to_string tm
    in
       ((Globals.show_types := old_show_types); res)
    end;

fun thm_to_string {output_width,show_assums,show_types} tm = 
    let val old_show_types = (!Globals.show_types) 
        val _ = (Globals.show_types := show_types)
        val res = Thm.thm_to_string tm
    in
       (Globals.show_types := old_show_types; res)
    end;

fun goal_to_string 
        {output_width,
         number_assums,
         show_types,
         first_assum_on_top} (asms,tm) = 
     let
        fun asmconv i asm = 
   	    [(if (number_assums) then (int_to_string i) else ""),
   	  	  " [ ", (Hol_pp.term_to_string asm) , " ]\n"];
        fun asmtext i asms = 
   	   if (null asms) then []
   	   else 
   	      let val text = asmconv i (hd asms) 
              in
   	  	  if (first_assum_on_top) 
                  then text@(asmtext (i+1) (tl asms))
   	  	  else (asmtext (i+1) (tl asms))@text
   	      end 
        val old_show_types = (!Globals.show_types) 
        val _ = (Globals.show_types := show_types)
        val res = end_itlist concat ((Hol_pp.term_to_string tm)::"\n\n"::(asmtext 1 asms))
     in
        (Globals.show_types := old_show_types; res)
     end;

end;
