(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




signature PretermOps_sig = sig
        type preterm
        type preterm_in_env
        val preterm_to_preterm_in_env: preterm -> preterm_in_env
        val term_to_preterm: term -> preterm
        val dest_Var: preterm -> string
        val is_Var: preterm -> bool
        val dest_Const: preterm -> string
        val is_Const: preterm -> bool
        val dest_Comb : preterm -> (preterm * preterm)
        val strip_Comb : preterm -> (preterm * preterm list)
        val is_Comb : preterm -> bool
        val preterm_rand : preterm -> preterm
        val preterm_rator : preterm -> preterm
        val dest_Abs : preterm -> (string * preterm)
        val is_Abs : preterm -> bool
        val dest_Constrained : preterm -> (preterm * hol_type)
        val is_Constrained : preterm -> bool
        val dest_List : preterm -> preterm list
        val is_List : preterm -> bool
        val dest_Tuple : preterm -> preterm list
        val dest_Varstruct : preterm -> string list
        val is_Varstruct : preterm -> bool
        val dest_Conj : preterm -> (preterm * preterm)
        val is_Conj : preterm -> bool
        val Conjuncts : preterm -> preterm list
        val dest_Disj : preterm -> (preterm * preterm)
        val is_Disj : preterm -> bool
        val Disjuncts : preterm -> preterm list
        val dest_Imp : preterm -> (preterm * preterm)
        val is_Imp : preterm -> bool
        val dest_Eq : preterm -> (preterm * preterm)
        val is_Eq : preterm -> bool
        val dest_Forall : preterm -> (string * preterm)
        val is_Forall : preterm -> bool
        val dest_Exists : preterm -> (string * preterm)
        val is_Exists : preterm -> bool

        val mk_Var : string -> preterm_in_env
        val mk_Const : string -> preterm_in_env
        val mk_Comb : (preterm_in_env * preterm_in_env) -> preterm_in_env
        val mk_Constrained : (preterm_in_env * hol_type) -> preterm_in_env
        val list_mk_Comb : (preterm_in_env * preterm_in_env list) -> preterm_in_env
        val mk_Abs : (string * preterm_in_env) -> preterm_in_env
        val mk_Pair : (preterm_in_env * preterm_in_env) -> preterm_in_env
        val mk_Tuple : preterm_in_env list -> preterm_in_env
        val mk_Varstruct : string list -> preterm_in_env
        val mk_Pabs : (string list * preterm_in_env) -> preterm_in_env
        val mk_List : preterm_in_env list -> preterm_in_env
        val mk_Conj : (preterm_in_env * preterm_in_env) -> preterm_in_env
        val list_mk_Conj : preterm_in_env list -> preterm_in_env
        val mk_Disj : (preterm_in_env * preterm_in_env) -> preterm_in_env
        val list_mk_Disj : preterm_in_env list -> preterm_in_env
        val mk_Imp : (preterm_in_env * preterm_in_env) -> preterm_in_env
        val mk_Eq : (preterm_in_env * preterm_in_env) -> preterm_in_env
        val mk_Forall : (string * preterm_in_env) -> preterm_in_env
        val list_mk_Forall : (string list * preterm_in_env) -> preterm_in_env
        val mk_Exists : (string * preterm_in_env) -> preterm_in_env
        val list_mk_Exists : (string list * preterm_in_env) -> preterm_in_env
        val list_mk_ResForall : ((string * preterm_in_env) list * preterm_in_env) -> preterm_in_env
        val list_mk_ResExists : ((string * preterm_in_env) list * preterm_in_env) -> preterm_in_env

        val mk_Pforall : (string list * preterm_in_env) -> preterm_in_env
        val mk_Pexists : (string list * preterm_in_env) -> preterm_in_env

        val Frees : preterm -> string list
        val prime_Var : (string * int) -> string
        val takeprime_Var : string -> string
        val unprime_Var : string -> (string * int)
        val isprime_Var : string -> bool
        val prime_Varstruct : (string list * int) -> string list
        val takeprime_Varstruct : string list -> string list
        val unprime_Varstruct : string list -> (string list * int)
end;


