(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




(*----------------------------------------------------------------------------
 -
 -----------------------------------------------------------------------------*)

signature Z_sig =
sig

    val primes : int -> string
    val prime : (string * int) -> string
    val takeprime : string -> string
    val unprime : string -> (string * int)
    val prime_var : (term * int) -> term
    val takeprime_var : term -> term
    val unprime_var : term -> (term * int)

    type varstruct
    val prime_varstruct : (varstruct * int) -> varstruct
    val takeprime_varstruct : varstruct -> varstruct
    val unprime_varstruct : varstruct -> (varstruct * int)

    val dest_varstruct : varstruct -> term list
    val mk_varstruct : term list -> varstruct
    val is_varstruct : term -> bool

    type varl
    val dest_varl : varl -> term list
    val mk_varl : term list -> term list
    val prime_varl : (varl * int) -> varl
    val takeprime_varl : varl -> varl
    val unprime_varl : varl -> (varl * int)


    val is_defined_schema : string -> bool
    val register_defined_schema : {name:string,theory:string} -> unit
    val definition_for_defined_schema : string -> thm
    val varstruct_for_defined_schema : string -> varstruct
    val defined_schemas : unit -> (string * thm) list
    val force_schema_constant : string -> unit


    val dest_zand : term -> (term * term)
    val dest_zor : term -> (term * term)
    val dest_zimp : term -> (term * term)
    val dest_znot : term -> term
    val mk_zand : (term * term) -> term
    val mk_zor : (term * term) -> term
    val mk_zimp : (term * term) -> term
    val mk_znot : term -> term
    
    val is_schema_application : term -> bool
    val dest_schema_application : term -> term
    val mk_schema_application : term -> term

    val is_schema_usage : term -> bool
    val dest_schema_usage : term -> term
    val mk_schema_usage : term -> term

    val is_schema : term -> bool
    val varstruct_for_schema : term -> term
    val sig_for_schema : term -> term
    val theta_for_schema : term -> term

    val is_schema_constant : term -> bool
    val dest_schema_constant : term -> string
    val mk_schema_constant : string -> term
    
    val is_SCHEMA : term -> bool
    val mk_SCHEMA : {body:term list, decs:term list, schemas:term list} -> term
    val dest_SCHEMA : term -> {body:term list, decs:term list, schemas:term list}

    val is_schema_or : term -> bool
    val mk_schema_or : (term * term) -> term
    val dest_schema_or : term -> (term * term)

    val is_schema_and : term -> bool
    val mk_schema_and : (term * term) -> term
    val dest_schema_and : term -> (term * term)

    val is_schema_imp : term -> bool
    val mk_schema_imp : (term * term) -> term
    val dest_schema_imp : term -> (term * term)

    val is_schema_not : term -> bool
    val mk_schema_not : term -> term
    val dest_schema_not : term -> term

    val is_pred_schema_binder : 
                (term -> {Bvar:term,Body:term}) -> term -> bool
    val mk_pred_schema_binder : 
                ({Bvar:term,Body:term} -> term) -> 
                {schema:term,body:term} -> 
                term
    val dest_pred_schema_binder : 
                (term -> {Bvar:term,Body:term}) -> 
                term -> 
                {schema:term,body:term}

    val is_pred_schema_forall : term -> bool
    val mk_pred_schema_forall : {schema:term,body:term} -> term
    val dest_pred_schema_forall : term -> {schema:term,body:term}

    val is_pred_schema_exists : term -> bool
    val mk_pred_schema_exists : {schema:term,body:term} -> term
    val dest_pred_schema_exists : term -> {schema:term,body:term}

end;

signature Zxi_delta_sig =
sig
    val is_delta : term -> bool
    val mk_delta : string -> term
    val dest_delta : term -> string

    val is_xi : term -> bool
    val mk_xi : string -> term
    val dest_xi : term -> string
end;


