#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc establishTextBehaviours { } {
    foreach event "
        <Button-1> 
        <B1-Motion> 
        <Double-Button-1> 
        <Triple-Button-1> 
        <Shift-Button-1> 
        <Double-Shift-Button-1> 
        <Triple-Shift-Button-1> 
        <B1-Leave> 
        <B1-Enter> 
        <ButtonRelease-1> 
        <Control-Button-1> 
        <Key-Left> 
        <Key-Right> 
        <Key-Up> 
        <Key-Down> 
        <Shift-Key-Left> 
        <Shift-Key-Right> 
        <Shift-Key-Up> 
        <Shift-Key-Down> 
        <Control-Key-Left> 
        <Control-Key-Right> 
        <Control-Key-Up> 
        <Control-Key-Down> 
        <Control-Shift-Key-Left> 
        <Control-Shift-Key-Right> 
        <Control-Shift-Key-Up> 
        <Control-Shift-Key-Down> 
        <Key-Prior> 
        <Shift-Key-Prior> 
        <Key-Next> 
        <Shift-Key-Next> 
        <Control-Key-Prior> 
        <Control-Key-Next> 
        <Key-Home> 
        <Shift-Key-Home> 
        <Key-End> 
        <Shift-Key-End> 
        <Control-Key-Home> 
        <Control-Shift-Key-Home> 
        <Control-Key-End> 
        <Control-Shift-Key-End> 
        <Key-Tab> 
        <Shift-Key-Tab> 
        <Control-Key-Tab> 
        <Control-Shift-Key-Tab> 
        <Control-Key-i> 
        <Key-Return> 
        <Key-Delete> 
        <Key-BackSpace> 
        <Control-Key-space> 
        <Key-Select> 
        <Control-Shift-Key-space> 
        <Shift-Key-Select> 
        <Control-Key-slash> 
        <Control-Key-backslash> 
        <Key-F16>
        <Key-F20>
         <Key-F18> 
        <Key-Insert>
         <Key> 
        <Alt-Key>
         <Meta-Key> 
        <Control-Key>
         <Key-Escape>
         <Key-KP_Enter> 
        <Control-Key-a> 
        <Control-Key-b>
         <Control-Key-d> 
        <Control-Key-e>
         <Control-Key-f> 
        <Control-Key-k> 
        <Control-Key-n> 
        <Control-Key-o> 
        <Control-Key-p>
         <Control-Key-t> 
        <Control-Key-v> 
        <Meta-Key-b> 
        <Meta-Key-d>
         <Meta-Key-f> 
        <Meta-Key-less> 
        <Meta-Key-greater> 
        <Meta-Key-BackSpace>
         <Meta-Key-Delete>
         <Meta-Key-w>
         <Control-Key-w>
         <Control-Key-y>
         <Control-Key-h> 
        <ButtonRelease-2>
    " {
        bind TextMisc $event [bind Text $event]
    }
    foreach event "
        <Button-1> 
        <B1-Motion> 
        <Double-Button-1> 
        <Triple-Button-1> 
        <Shift-Button-1> 
        <Double-Shift-Button-1> 
        <Triple-Shift-Button-1> 
        <B1-Leave> 
        <B1-Enter> 
        <ButtonRelease-1> 
        <Control-Button-1> 
        <Key-Left> 
        <Key-Right> 
        <Key-Up> 
        <Key-Down> 
        <Shift-Key-Left> 
        <Shift-Key-Right> 
        <Shift-Key-Up> 
        <Shift-Key-Down> 
        <Control-Key-Left> 
        <Control-Key-Right> 
        <Control-Key-Up> 
        <Control-Key-Down> 
        <Control-Shift-Key-Left> 
        <Control-Shift-Key-Right> 
        <Control-Shift-Key-Up> 
        <Control-Shift-Key-Down> 
        <Key-Prior> 
        <Shift-Key-Prior> 
        <Key-Next> 
        <Shift-Key-Next> 
        <Control-Key-Prior> 
        <Control-Key-Next> 
        <Key-Home> 
        <Shift-Key-Home> 
        <Key-End> 
        <Shift-Key-End> 
        <Control-Key-Home> 
        <Control-Shift-Key-Home> 
        <Control-Key-End> 
        <Control-Shift-Key-End> 
        <Key-Tab> 
        <Shift-Key-Tab> 
        <Control-Key-Tab> 
        <Control-Shift-Key-Tab> 
        <Control-Key-i> 
        <Key-Return> 
        <Control-Key-space> 
        <Key-Select> 
        <Control-Shift-Key-space> 
        <Shift-Key-Select> 
        <Control-Key-slash> 
        <Control-Key-backslash> 
        <Key-F16>
        <Key-F20>
         <Key-F18> 
        <Key-Insert>
         <Key> 
        <Alt-Key>
         <Meta-Key> 
        <Control-Key>
         <Key-Escape>
         <Key-KP_Enter> 
        <Control-Key-a> 
        <Control-Key-b>
        <Control-Key-e>
         <Control-Key-f> 
        <Control-Key-k> 
        <Control-Key-n> 
        <Control-Key-o> 
        <Control-Key-p>
         <Control-Key-t> 
        <Control-Key-v> 
        <Meta-Key-b> 
         <Meta-Key-f> 
        <Meta-Key-less> 
        <Meta-Key-greater> 
        <Meta-Key-BackSpace>
         <Control-Key-y>
         <Control-Key-h> 
    " {
        set class_binding [bind Text $event]
        bind TextConstrainedEdit $event "text::constrained_movement_check \{$class_binding\} %W"
    }

# These deletion operations have been taken out of the TextConstrainedEdit
# behaviour since they can break the constraint, especially around the edges.
# Some are redefined below.
#       <ButtonRelease-2> 
#       <Key-Delete> 
#       <Key-BackSpace> 
#        <Control-Key-d> 
#       <Meta-Key-d>
#        <Meta-Key-w>
#        <Control-Key-w>
#        <Meta-Key-Delete>


    foreach event {
        <Button-2> 
        <B2-Motion> 
    } {
        bind TextScan $event [bind Text $event]
    }

}


proc text::constrained_movement_check { command textw } {
    uplevel #0 $command 
    if {[$textw compare insert < LEFT_LIMIT]} { 
        $textw mark set insert "LEFT_LIMIT"
    }
    if {[$textw compare insert >= RIGHT_LIMIT]} { 
        $textw mark set insert "RIGHT_LIMIT"
    }
}

bind TextConstrainedEdit <Delete> {
    if {[%W tag nextrange sel 1.0 end] != ""} {
        %W delete sel.first sel.last
    } elseif {[%W compare insert >= "RIGHT_LIMIT - 1 c"]} {
        break
    } else {
        %W delete insert
        %W see insert
    }
}
bind TextConstrainedEdit <BackSpace> {
    if {[%W tag nextrange sel 1.0 end] != ""} {
        %W delete sel.first sel.last
    } elseif {[%W compare insert <= LEFT_LIMIT]} {
        break
    } elseif [%W compare insert != 1.0] {
        %W delete insert-1c
        %W see insert
    }
}



