#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





#-------------------------------------------------------------------------
# General routines (shared by goals, terms, types and theorems)
#-------------------------------------------------------------------------

proc HolPP::generate { code ppfun kind flagsvar } {
        global TheoremWidgets_flags
        TheoremWidgets::delayedLoadStructuredText
# puts "HolPP::generate (1)"
        upvar 1 $flagsvar flags
        if ![info exists flags(interfaceMaps)] { 
            if $flags(richtext) { 
                set flags(interfaceMaps) $TheoremWidgets_flags(interfaceMaps) 
            } else {
                set flags(interfaceMaps) ""
            }
        }
        

        if ![info exists flags(firstAssumOnTop)] { set flags(firstAssumOnTop) $TheoremWidgets_flags(firstAssumOnTop) }
        if ![info exists flags(goalLine)] { set flags(goalLine) $TheoremWidgets_flags(goalLine) }
        if ![info exists flags(numberAssums)] { set flags(numberAssums) $TheoremWidgets_flags(numberAssums) }
        if ![info exists flags(showAssums)] { set flags(showAssums) $TheoremWidgets_flags(showAssums) }
        if ![info exists flags(showRestrictions)] { set flags(showRestrictions) $TheoremWidgets_flags(showRestrictions) }
        if ![info exists flags(showTypes)] { set flags(showTypes) $TheoremWidgets_flags(showTypes) }
        if ![info exists flags(wrapTerms)] { set flags(wrapTerms) 0 }

return [ML -type stringlistlist "HolPPToStrings.val_to_strings
HolBranches.string_of_branch
\{initial_kind=[ml_string $kind],ppfun=$ppfun\}
\{interface_maps=mapfilter InterfaceMapsRegistry.find_interface_map \n[ml_stringlist $flags(interfaceMaps)],
parameters=\{
   context=[ml_string ""], 
   first_assum_on_top=[ml_bool $flags(firstAssumOnTop)],
   goal_line=[ml_string $flags(goalLine)], 
   number_hyp=[ml_bool $flags(numberAssums)], 
   show_assums=[ml_bool $flags(showAssums)],
   show_restrictions=[ml_bool $flags(showRestrictions)], 
   show_types=[ml_bool $flags(showTypes)],
   wrap_terms=[ml_bool $flags(wrapTerms)]\}
\}
$flags(width) ($code)
"]


}


proc HolPP::select_subobject { class textw objspec path } {
        # puts "In HolPP::select_subobject, class = $class, textw = $textw, objspec = $objspec, path = $path"
        global vals
        set operations ""
        set hol_termpath  ""
        
        set outermost_term_access ""
        foreach item $path {
            switch -glob -- $item {
                HY?* { 
                    regexp HY(.*) $item dummy hyp
                    switch -- $class THM {
                        set operation "el $hyp o hyp"
                    } GOAL { 
                        set operation "el $hyp o fst"
                    }
                    set outermost_term_access [linsert $outermost_term_access 0 $operation]
                }
                L { set operation rator ; lappend hol_termpath HolTermPaths.RATOR\n }
                R { set operation rand ; lappend hol_termpath HolTermPaths.RAND\n }
                B { set operation body ; lappend hol_termpath HolTermPaths.BODY\n }
                EX { set operation bvar }
                TA?* { 
                    regexp TA(.*) $item dummy tyarg
                    set operation "el $tyarg o #Args o dest_type"
                }
                C { 
                    switch -- $class THM {
                        set operation "concl"
                    } GOAL { 
                        set operation "snd"
                    }
                    set outermost_term_access [linsert $outermost_term_access 0 $operation]
                }
                TY { set operation type_of }
                default { error "unknown location identifier $item in term tag" }
            }
            set operations [linsert $operations 0 $operation]
        }
        if {[llength $path] == 0} {
            switch -glob -- $class THM { 
                set selection_types {HOL_THMCODE STRING} 
            } GOAL { 
                set selection_types ""
            }
        } else {
            switch -glob -- $item {
                HY?* { set selection_types {HOL_TERMCODE HOL_TERM STRING} }
                TA?* { set selection_types {HOL_TYPECODE HOL_TYPE STRING} }
                TY { set selection_types {HOL_TYPECODE HOL_TYPE STRING} }
                EX { set selection_types {HOL_TERMCODE HOL_TERM} }
                default { set selection_types {HOL_TERMCODE HOL_TERM HOL_TERMPATTERN STRING HOL_TERMPATH} }
            }
        }
        catch {
            unset vals(selection,HOL_TERMPATH)
            unset vals(selection,HOL_TERMCODE)
            unset vals(selection,HOL_TYPECODE)
            unset vals(selection,HOL_THMCODE)
        }
        set objcode ([$class::code $objspec])
        if {[llength $operations]==0} {
            set mlcode $objcode
        } else {
            set mlcode "(([join $operations " o \n"]) $objcode)"
        }
        if {[llength $outermost_term_access]==0} {
            set outermost_term_access_code $objcode
        } else {
            set outermost_term_access_code "(([join $outermost_term_access " o \n"]) $objcode)"
        }
        set vals(selection,HOL_TERMPATH) [ml_list $hol_termpath]
        set vals(selection,HOL_OUTERMOST_TERM_CODE) $outermost_term_access_code
        set code_selection_type [lindex $selection_types 0]
        set vals(selection,$code_selection_type) $mlcode
        foreach selection_type $selection_types {
            selection handle $textw "HolPP::provide_selection_$selection_type" $selection_type
        }
        #puts "textw = $textw, get = [selection get]"
        #puts "selection own = [selection own]"
        return $selection_types
}

proc HolPP::provide_selection_STRING { from size } {
        global vals
        global TheoremWidgets_flags
        if [info exists vals(selection,HOL_TERMCODE)] {
            set text [hol_term [ML "Plaintext.term_to_string \{
                                output_width=72,
                                show_types=[ml_bool $TheoremWidgets_flags(pasteWithTypes)]
                        \} $vals(selection,HOL_TERMCODE)"]]
        } elseif [info exists vals(selection,HOL_THMCODE)] {
            set text $vals(selection,HOL_THMCODE)
        } elseif [info exists vals(selection,HOL_TYPECODE)] {
            set text [hol_type [ML "type_to_string $vals(selection,HOL_TYPECODE)"]]
        } else {
            error "no STRING selection"
        }
#       puts "selection = [string range $text $from [expr $from+$size-1]]"
        puts "text = $text"
        return [string range $text $from [expr $from+$size-1]]
}
proc HolPP::provide_selection_HOL_TERMCODE { from size } {
        global vals
        string range $vals(selection,HOL_TERMCODE) $from [expr $from+$size-1]
}
proc HolPP::provide_selection_HOL_TERMPATH { from size } {
        global vals
        string range $vals(selection,HOL_TERMPATH) $from [expr $from+$size-1]
}
proc HolPP::provide_selection_HOL_TERMPATTERN { from size } {
        global vals
        set text "(-|`[ML "HolTermPatterns.string_of_termpattern 
(HolTermPatterns.general_matching_termpattern 
  ($vals(selection,HOL_TERMPATH),
   $vals(selection,HOL_OUTERMOST_TERM_CODE) ))"]`|-)"
        string range $text $from [expr $from+$size-1]
}
proc HolPP::provide_selection_HOL_TERM { from size } {
        global vals
        upvar #0 $w data
            set text [hol_term [ML "Plaintext.term_to_string \{
                                output_width=72,
                                show_types=true
                        \} $vals(selection,HOL_TERMCODE)"]]
        string range $text $from [expr $from+$size-1]
}

proc HolPP::provide_selection_HOL_TYPECODE { from size } {
        global vals
        string range $vals(selection,HOL_TYPECODE) $from [expr $from+$size-1]
}

proc HolPP::provide_selection_HOL_THMCODE { from size } {
        global vals
        string range $vals(selection,HOL_THMCODE) $from [expr $from+$size-1]
}


