#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc modalDialog {args} {
        global modal_priv
        set w [uplevel 1 $args]
        set modal_priv(grab,$w) [grab current $w]
        catch {grab set $w}
        
        button_setDefault $w
        focus -force [focus -lastfor $w]

        if {[wm protocol $w WM_DELETE_WINDOW]==""} {
            wm protocol $w WM_DELETE_WINDOW "if \[catch \{$w cancel\}\] \{ destroy $w \}"
        }
        return $w
}

# Procedure:    modalDialog.end
#
# Synopsis:
#       Release a modal dialog.
#
# Usage:
#c      modalDialog.end pathName
#
# Parameters:
#c      pathName
#               Name of a widget that has been made modal via modalDialog
#
# Return value:
#       None.
#
# Description:
#       modalDialog.end ends a modal dialog.  It releases a grab on the
#       specified widget, directs the focus to where it was before the
#       modal dialog began, and destroys the widget.
#
# Bugs:
#       Widget destruction should be orthogonal to the modal dialog. (?)

proc modalDialog.end w {
        global modal_priv
        grab release $w
        if {$modal_priv(grab,$w) != ""} {
                grab set $modal_priv(grab,$w)
        }
        unset modal_priv(grab,$w)
        
        after 1 "catch \{destroy $w\}"
}
