#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------



proc button_bindForDefault {w {controlonly ""}} {
        if {$controlonly == "-controlonly"} { 
            set prefix "Control-" 
        } else {
            set prefix ""
        }
        bind $w <Control-Key-j> {button_invokeDefault %W}
        bind $w <Control-Key-m> {button_invokeDefault %W}
        catch { bind $w <[set prefix]Key-Linefeed> {button_invokeDefault %W} }
        catch { bind $w <[set prefix]Key-Return> {button_invokeDefault %W} }
        catch { bind $w <[set prefix]Key-KP_Enter> {button_invokeDefault %W} }
        catch { bind $w <[set prefix]Key-Enter> {button_invokeDefault %W} }
}

proc button_invoke {w {default {-nodefault}}} {
        global button_priv
        if {$default == [string range "-default" 0 \
                                [expr [string length $default]-1]]} {
                button_makeDefault $w
        }
        if {[winfo class $w] == "Button"} {
                set screen [winfo screen $w]
                if {![info exists button_priv(current,$screen)] 
                    || $button_priv(current,$screen) != $w} {
                        uplevel #0 [list $w flash]
                }
        }
        uplevel #0 [list $w invoke]
}



proc button_makeDefault w {
        global button_priv
#       if {[$w cget -state] == "disabled"} return
        set t [winfo toplevel $w]
        set button_priv(default,$t) $w
        bind $t <Destroy> "+catch \"unset button_priv(default,$t)\""
}

proc button_invokeDefault w {
        global button_priv
        set t [winfo toplevel $w]
        if {[info exists button_priv(default,$t)]} {
                set b $button_priv(default,$t)
                if {![winfo exists $b] \
                    || [info commands $b] != $b \
                    || [lindex [$b config -state] 4] == "disabled"} {
                        unset b
                }
        }
        if {![info exists b]} {
                set b [button:findDefault $t]
        }
        if {$b == ""} {
                error "No command to invoke"
        }
        button_invoke $b
}


proc button:findDefault w {
        global tk_version
        case [winfo class $w] in {
                {Button Checkbutton Radiobutton} {
                        if {[lindex [$w config -state] 4] != "disabled"} {
                                return $w
                        }
                }
        }
        set kids [winfo children $w]
        if {$tk_version >= 3.3} {
                set init {set i 0}
                set cond {$i < [llength $kids]}
                set reinit {incr i}
        } else {
                set init {set i [expr [llength $kids]-1]}
                set cond {$i >= 0}
                set reinit {incr i -1}
        }
        for $init $cond $reinit {
                set kid [lindex $kids $i]
                if {$kid != [winfo toplevel $kid]} {
                        set d [button:findDefault $kid]
                        if {$d != ""} {
                                return $d
                        }
                }
        }
        return ""
}


proc button_setDefault w {
        global button_priv
        if [info exists button_priv(default,[winfo toplevel $w])] {
                return $button_priv(default,[winfo toplevel $w])
        }
        set db [button:findDefault $w]
        if {$db != ""} {
                button_makeDefault $db
        }
        return $db
}


