#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




#for autoloading
proc listedit { } { }

composite_define ListEdit {
        {-variable variable Variable listeditorvar composite_configLocal}
} listedit::initProc

composite_configFlag ListEdit variable {w option value} {
        listedit::remove_trace $w
        listedit::add_trace $w $value
        return private
}


proc listedit::remove_trace { w } {     
        upvar #0 config$w config
        upvar #0 $config(variable) old_var
        # puts "config(variable) = $config(variable)"
        trace vdelete old_var w "listedit::variable_change $w"
}

proc listedit::add_trace { w new_var } {        
        upvar #0 $new_var variable
        if {![info exists variable]} { set variable "" }

        trace variable variable w "listedit::variable_change $w"
        listedit::variable_change $w
}

proc listedit::initProc { w } { 
        global gui_flags
        upvar #0 config$w config

        pack [frame $w.fr] -side left -expand yes -fill both        
        pack [entry $w.entry \
                -textvariable vals($w,entry) \
                -relief sunken \
                -borderwidth 2 \
                -font $gui_flags(font,textentry)] \
            -fill x -in $w.fr
        
        pack [scrollable listbox $w.listbox \
                -font $gui_flags(font,listboxes) \
                -borderwidth 2 \
                -relief sunken]  \
           -side left -in $w.fr -expand yes -fill both

        pack [frame $w.buttons] \
            -side right -pady 5 -padx 5

        pack [button $w.buttons.insert \
                -width 6 \
                -text Insert \
                -command "$w insert" \
                -font $gui_flags(font,buttons)] \
            -side top

        pack [button $w.buttons.change \
                -width 6 \
                -text Change \
                -command "$w change" \
                -font $gui_flags(font,buttons)] \
            -side top

        pack [button $w.buttons.delete \
                -width 6 \
                -text Delete \
                -command "$w delete" \
                -font $gui_flags(font,buttons)] \
            -side top

        pack [button $w.buttons.sort \
                -width 6 \
                -text Sort \
                -command "$w sort" \
                -font $gui_flags(font,buttons)] \
            -side top

        # default bindings

        bind $w.listbox.b <Any-B1-Motion> [list $w select %y]
        bind $w.listbox.b <Any-Button-1> [list $w select %y]
        bind $w.entry <Any-Return> "$w insert"
    
        listedit::add_trace $w $config(variable) 

        bind $w <Destroy> "+
                listedit::remove_trace $w
                unset_vals_for_widget $w
        "
        return $w
}

composite_subcommand ListEdit select { w y } {
        global vals
        upvar #0 vals($w,entry) entryvar
        set i [$w.listbox.b nearest $y]
        $w.listbox.b select from $i
        set entryvar [$w.listbox.b get $i]
}

composite_subcommand ListEdit listbox { w args } {
        if {[llength $args] == 0} {
            return  $w.listbox.b
        } else {
            eval $w.listbox.b $args
        }
}

composite_subcommand ListEdit insert { w } {
        upvar #0 config$w config
        upvar #0 $config(variable) var
        lappend var [$w.entry get]
}

composite_subcommand ListEdit change { w } {
        upvar #0 config$w config
        upvar #0 $config(variable) var
        set var [lreplace $var [$w.listbox.b cursel] [$w.listbox.b cursel] [$w.entry get]]
}

composite_subcommand ListEdit delete { w } {
        upvar #0 config$w config
        upvar #0 $config(variable) var
        set var [lreplace $var [$w.listbox.b cursel] [$w.listbox.b cursel]]
}
composite_subcommand ListEdit sort { w } {
        upvar #0 config$w config
        upvar #0 $config(variable) var
        set var [lsort $var]
}


proc listedit::variable_change { w args } {
        # puts "listedit::variable_change, w = $w, args = $args"
        upvar #0 config$w config
        upvar #0 $config(variable) var

        set sel [$w.listbox.b cursel]
                
        $w.listbox.b delete 0 end
        foreach el $var {
                $w.listbox.b insert end $el
        }
        catch {
            upvar #0 vals($w,entry) entryvar
            $w.listbox.b select from $sel;
            set entryvar [$w.listbox.b get $sel]
        }
}

