#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




option add *TkTRS.sources "" widgetDefault
option add *TkTRS.resultsHandler "newwin TheoremsTopLevel -title {Search Results} -objspecs" widgetDefault

proc TkTRS { w args } {
        global gui_flags 
        global TkTRS_flags
        global feedback
        global busy
        incr busy
        global vals

        set ancestors 0
        set descendants 0
        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i] -resultsHandler {
                incr i
                set vals($w,resultsHandler) [lindex $args $i]
            } -sources {
                incr i
                set sources [lindex $args $i]
            } -descendants {
                incr i
                set descendants [lindex $args $i]
            } -ancestors {
                incr i
                set ancestors [lindex $args $i]
            } default {
                error "unrecognized arg [lindex $args $i]"
            }
        }



        TkTRS::delayed_Load
        toplevel $w -class TkTRS

        if ![info exists vals($w,resultsHandler)] { set vals($w,resultsHandler) [option get $w resultsHandler ResultsHandler] }
        if ![info exists sources] { set sources [option get $w sources Sources] }

        # 2. Do some windowing grunge.
        #

        wm withdraw $w
        wm title $w TkTRS
        
        set feedback [list {} "Creating TkTRS display..."]
        
        pack [frame $w.sources] -fill both -expand yes -padx 10 -pady 10

        pack [frame $w.ancestry]  -in $w.sources -side left -fill y -expand yes
        pack [fontcheck label $w.ancestry.lab -font $gui_flags(font,labels) -text "Don't Search:" -anchor w] -side top -fill x
        pack [scrollable listbox $w.ancestry.list \
                -relief sunken \
                -export false \
                -setgrid 1 \
                -font $gui_flags(font,listboxes)] -fill y -expand yes

        pack [frame $w.sourcelist] -in $w.sources -side right -fill y -expand yes
        pack [fontcheck label $w.sourcelist.lab -font $gui_flags(font,labels) -text "Search:" -anchor w]  -side top -fill x

        pack [scrollable listbox $w.sourcelist.list \
                -relief sunken \
                -export false \
                -setgrid 1 \
                -font $gui_flags(font,listboxes)] \
            -side left -fill y

        pack [frame $w.sources.controls] -side left -pady 20 -padx 5
        pack [fontcheck button $w.sources.controls.add \
                -text ">>>" \
                -command "TkTRS::movesources $w [$w.ancestry.list listbox] [$w.sourcelist.list listbox] 0 0" \
                -width 14]
        pack [fontcheck button $w.sources.controls.addparents \
                -text "ancestors >>>" \
                -command "TkTRS::movesources $w [$w.ancestry.list listbox] [$w.sourcelist.list listbox] 1 0" -width 14]
        pack [fontcheck button $w.sources.controls.adddesc \
                -text "descendants >>>" \
                -command "TkTRS::movesources $w [$w.ancestry.list listbox] [$w.sourcelist.list listbox] 0 1" -width 14]
        pack [fontcheck button $w.sources.controls.remove \
                -text "<<<" -font $gui_flags(font,buttons) \
                -command "TkTRS::movesources $w [$w.sourcelist.list listbox] [$w.ancestry.list listbox] 0 0" -width 14]
        pack [fontcheck button $w.sources.controls.removeparents \
                -text "<<< ancestors" \
                -command "TkTRS::movesources $w [$w.sourcelist.list listbox] [$w.ancestry.list listbox] 1 0" -width 14]
        pack [fontcheck button $w.sources.controls.removedesc \
                -text "<<< descendants" \
                -command "TkTRS::movesources $w [$w.sourcelist.list listbox] [$w.ancestry.list listbox] 0 1" -width 14]



        #---------------

        pack [frame $w.patt -relief sunken -borderwidth 2] -fill x -pady 5 -padx 10
        pack [frame $w.patt.kind] -fill x -pady 5
        pack [fontcheck label $w.patt.kind.lab \
                -font $gui_flags(font,labels) \
                -text "Find:" \
                -anchor w] -side left -padx 10
        pack [fontcheck checkbutton $w.patt.kind.axioms \
                -variable vals($w,axioms) \
                -onvalue "TRS_user.kind TRS_matching.Axiom" \
                -offvalue "TRS_matching.Any" \
                -font $gui_flags(font,labels) \
                -text "Axioms" \
                -relief flat \
                -anchor w] -fill x
        set vals($w,axioms) "TRS_user.kind TRS_matching.Axiom"
        pack [fontcheck checkbutton $w.patt.kind.definitions \
                -variable vals($w,definitions) \
                -onvalue "TRS_user.kind TRS_matching.Definition" \
                -offvalue "TRS_matching.Any" \
                -font $gui_flags(font,labels) \
                -text "Definitions" \
                -relief flat \
                -anchor w] -fill x
        set vals($w,definitions) "TRS_user.kind TRS_matching.Definition"
        pack [fontcheck checkbutton $w.patt.kind.theorems \
                -variable vals($w,theorems) \
                -onvalue "TRS_user.kind TRS_matching.Theorem" \
                -offvalue "TRS_matching.Any" \
                -font $gui_flags(font,labels) \
                -text "Theorems" \
                -relief flat \
                -anchor w] -fill x
        set vals($w,theorems) "TRS_user.kind TRS_matching.Theorem"
        
        
        pack [frame $w.patt.against] -fill x -pady 5
        pack [fontcheck label $w.patt.against.lab \
                -font $gui_flags(font,labels) \
                -text "Which Match:" \
                -anchor w] -side left -padx 10
        pack [fontcheck entry $w.patt.against.val \
                -textvariable vals($w,match_val) \
                -font $gui_flags(font,codeentry) \
                -relief sunken] -fill x -padx 5

        pack [frame $w.patt.using] -fill x -pady 5
        pack [fontcheck label $w.patt.using.lab \
                -font $gui_flags(font,labels) \
                -text "Using:" \
                -anchor w] -side left -padx 10
        pack [fontcheck radiobutton $w.patt.using.name\
                -variable vals($w,match_type) \
                -value name \
                -font $gui_flags(font,labels) \
                -text "Glob Style Matching Against Theorem Name" \
                -relief flat \
                -anchor w] -fill x
        pack [fontcheck radiobutton $w.patt.using.concl \
                -variable vals($w,match_type) \
                -value concl \
                -font $gui_flags(font,labels) \
                -text "Term Matching Against Theorem Conclusion" \
                -relief flat \
                -anchor w] -fill x
        pack [fontcheck radiobutton $w.patt.using.part_concl \
                -variable vals($w,match_type) \
                -value part_concl \
                -font $gui_flags(font,labels) \
                -text "Depth Term Matching Against Theorem Conclusion" \
                -relief flat \
                -anchor w]  -fill x

        bind $w.patt.using.concl <ButtonRelease-1> "+focus_goTo $w.patt.against.val; [bind Checkbutton <ButtonRelease-1>]"
        bind $w.patt.using.part_concl <ButtonRelease-1> "+focus_goTo $w.patt.against.val; [bind Checkbutton <ButtonRelease-1>]"
        bind $w.patt.using.name <ButtonRelease-1> "+focus_goTo $w.patt.against.val; [bind Checkbutton <ButtonRelease-1>]"

        pack [frame $w.controls]
        pack [fontcheck button $w.controls.search \
                -command "TkTRS::start_search $w" \
                -text "Start Search" \
                -width 12] -side left -fill x -padx 10 -pady 10
        set helpcommand "Help::tutorial TkTRS"
        pack [fontcheck button $w.controls.help \
                -command $helpcommand \
                -text "Help" \
                -width 7] \
            -side left -fill x -padx 5
        pack [fontcheck button $w.controls.close \
                -command "destroy $w" \
                -text "Close" \
                -width 12] \
            -side left -fill x -padx 10 -pady 10
        
        #---------------

        set ancestry [ML -type stringlist [hol_ancestry]]
        eval [list $w.ancestry.list listbox insert] end [lsort $ancestry]

        foreach source $sources {
            for {set i 0} {$i < [$w.ancestry.list listbox size]} {incr i} {
                if {[$w.ancestry.list listbox get $i]==$source} {
                        $w.ancestry.list listbox select clear 0 end
                        $w.ancestry.list listbox select set $i
                }
            }
            TkTRS::movesources $w [$w.ancestry.list listbox] [$w.sourcelist.list listbox] $ancestors $descendants
        }

        set vals($w,match_type) name
        set vals($w,kind) TRS_matching.Any
        set vals($w,match_val) "*"

        update
        focus_goToFirst $w.controls
        button_setDefault $w.controls.search
        update
        wm deiconify $w
        tkwait visibility $w
        update

        bind $w <Destroy> "+TkTRS::upon_destroy $w %W"

        incr busy -1
        return $w
}

proc TkTRS::upon_destroy { w realw } {
        if {$w==$realw} {
            unset_vals_for_widget $w
        }

}

#----------------------------------------------------------------------------
# TkTRS::movesources
#
#----------------------------------------------------------------------------

proc TkTRS::movesources { w from to ancestors descendants } {
        global feedback
        global busy
        incr busy
        
        set feedback [list $w "Transferring theories..."]
        set tomove ""
        foreach elem [$from curselection] {
            set root [$from get $elem]
            if {$root==""} continue
            if $ancestors {
                # catch since list might be null
                catch {eval lappend tomove [ML -type stringlist "[hol_ancestors] [ml_string $root]"]}
                lappend tomove $root
            } elseif $descendants {
                catch {eval lappend tomove [ML -type stringlist "[hol_descendants] [ml_string $root]"]}
                lappend tomove $root
            } else {
                lappend tomove $root
            }
        }
        foreach theory $tomove {
            for {set i 0} {$i < [$from size]} {incr i} {
                if {[$from get $i]==$theory} {
                        $from delete $i
                }
            }
        }
        set toinsert ""
        foreach x $tomove {
            if {[lsearch -exact $toinsert $x]==-1} {
                lappend toinsert $x
            }
        }
        for {set i 0} {$i < [$to size]} {incr i} {
            if {[lsearch -exact $toinsert [$to get $i]]==-1} {
                lappend toinsert [$to get $i]
            }
        }
        $to delete 0 end
        eval [list $to insert end] [lsort $toinsert]
        incr busy -1
}


#----------------------------------------------------------------------------
# TkTRS::thmpattern
#
#----------------------------------------------------------------------------


proc TkTRS::thmpattern { w } {
        global vals 
        set kind "TRS_matching.Orelse(\n$vals($w,axioms),\nTRS_matching.Orelse(\n$vals($w,theorems),\n$vals($w,definitions)))"
        set vals($w,match_val) [$w.patt.against.val get]
        case $vals($w,match_type) concl {
            set match "TRS_user.conc [hol_term $vals($w,match_val)]"
        } part_concl {
            set match "TRS_matching.Where (TRS_user.conc [hol_term any:bool], TRS_sidecond.contains(\n[hol_term any:bool],[hol_term $vals($w,match_val)]\n))"
        } name {
            set match "TRS_user.thmname [ml_string $vals($w,match_val)]"
        } 
        return "(TRS_matching.Andalso($kind,\n$match))"
}

proc TkTRS::sources { w } {
        set searchpaths ""
        for {set i 0} {$i < [$w.sourcelist.list listbox size]} {incr i} {
            lappend searchpaths "(TRS_search.Theory [ml_string [$w.sourcelist.list listbox get $i]])\n"
        }
        return $searchpaths
}


#----------------------------------------------------------------------------
# TkTRS::start_search
#
#----------------------------------------------------------------------------

proc TkTRS::start_search { w } {
        global feedback
        global busy

        incr busy

        # 1. Load the trs library if needed.
        
        TkTRS::delayed_Load
        global vals 

        set thmpattern [TkTRS::thmpattern $w]   
        set sources [TkTRS::sources $w]

        if [llength $sources]==0 {
            errormessage $w.error "Please specify some theories to search."
            incr busy -1
            return
        }

        set sourceml "(TRS_search.Paths [ml_list $sources])"
        set feedback [list $w "Starting Search..."]
        if [catch {ML -type stringlistlist -check 1 "
        let 
           [ml_fun] trs_thmkind_text thmkind = if (thmkind=TRS_matching.Axiom) then [ml_string axiom]
                                       else if (thmkind=TRS_matching.Definition) then [ml_string definition]
                                       else if (thmkind=TRS_matching.Theorem) then [ml_string theorem]
                                       else [ml_string {}]
           [ml_fun] foundthms_to_strings (thmkind,(thryname,(thmname,_))) = 
                        [ml_list [list thmname {(trs_thmkind_text thmkind)} thryname]] 
        in 
           map foundthms_to_strings (TRS_user.full_search \n$thmpattern \n$sourceml)
        end"} thms] { incr busy -1; errormessage $w.error $thms ; return }
        set specs ""
        foreach thmspec [lsort $thms] { 
            lappend specs [list [lindex $thmspec 0] [list THM $thmspec]] 
        }
        if {[set vals($w,resultsHandler)] == ""} {
            global search_results
            set search_results $specs
        } else {
            if {[llength $thms]==0} {
                errormessage $w.error "No matching theorems found."     
            } else {
                # puts "vals($w,resultsHandler) = $vals($w,resultsHandler), specs = $specs"
                eval $vals($w,resultsHandler) [list $specs]
            }
        }
        incr busy -1
        
}


#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc trs { } {
   after 1 {
        catch {destroy .trsdialog}
        source $TkTRS_library/src/TkTRS.tcl
        source $RichText_library/src/TheoremsTopLevel.tcl
        source $RichText_library/src/TheoremsFrame.tcl
        newwin TkTRS
   }
}

