(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)



signature TheoryNotification_sig = sig
        type client

        val add_client: string -> client -> unit
        val remove_client: string -> string -> unit
        val mk_client: 
                string *                                (* the theory being watched *)
                (string -> string -> thm -> unit) *     (* called when a new theorem is added to theory *)
                (string -> string -> thm -> unit) *     (* called when a new definition is added to theory *)
                (string -> string -> thm -> unit) *     (* called when a new axiom is added to theory *)
                (string -> term -> unit) *              (* called when a new constant is added to theory *)
                (string -> {Arity:int, Name:string} -> unit)            (* called when a new type is added to theory *)
                   -> client

        val define_type  : {fixities:fixity list, name:string, type_spec:term frag list} -> thm
        val new_definition : string * term -> thm
        val new_infix_definition : string * term * int -> thm
        val new_recursive_definition : {def:term, fixity:fixity, name:string, rec_axiom:thm} -> thm
        val new_specification : {consts:{const_name:string, fixity:fixity} list, name:string, sat_thm:thm} -> thm
        val save_thm : string * thm -> thm
        val store_thm : string * term * tactic -> thm
        val most_general_wrapper : ('a -> 'b) -> 'a -> 'b;
        
        val test : unit -> bool;
        val clients : unit -> (string * client) list;
end

