#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc PrefVar { item } { lindex $item 0 }
proc PrefXres { item } { lindex $item 1 }
proc PrefType { item } { lindex $item 2 }
proc PrefDefault { item } { lindex $item 3 }
proc PrefComment { item } { lindex $item 4 }
proc PrefHelp { item } { lindex $item 5 }

proc preferences::ProcessArgs { argc argv } {
    global pref 
    global gui_flags
    global install_dir_tkhol

    # these two operations reference tkhol specific things - not
    # so good.
    if [info exists install_dir_tkhol] {
        set appDefaults $install_dir_tkhol/tkhol-defaults
        # puts "appDefaults = $appDefaults"
        PreferencesReadFile $appDefaults startupFile
    }
    set userDefaults ~/.tkhol-defaults

    set pref(uid) 0
    set pref(panes) {}
    set pref(userDefaults) $userDefaults

        PreferencesReadFile $userDefaults user


    Preferences_Add "General Preferences" \
"Window placement and scroll-related preferences are set here.
Contrained scrolling keeps the last line of text in a window stuck
to the bottom of the window.
NOTE: All of these are not yet implemented in $gui_flags(title).

You can also choose whether to save preferences on exit." [list \
        [list gui_flags(menuTriggerModifiers) menuTriggerModifiers {CHOICE Any-Meta Any-Alt Shift-Meta Shift-Alt Ctrl-Meta Ctrl-Alt} Any-Alt {Keyboard Menu Trigger} "The combination of modifiers that have to be pressed in combination with a letter to trigger a pulldown menu.  On some keyboards there is no Alt key, hence the need to choose another keyboard combination.  This only takes effect after you restart $gui_flags(title)."] \
        [list gui_flags(scrollbarSide) scrollbarSide {CHOICE right left} right {Scrollbar side} "Which side the scrollbars appear on.  This only takes effect after you restart $gui_flags(title)."] \
        [list gui_flags(scrollSpeed) scrollSpeed NUM 1 {Drag-Scroll speed} "How fast things scroll when you drag a text widget around with the (by default) middle button."] \
        [list gui_flags(scrollAccel) scrollAccel NUM 4 {Drag-Scroll acceleration} "How fast things scroll when you drag a text widget around with the (by default) middle button with Shift depressed."] \
        [list widgetText(constrained) textConstrainScroll BOOL 0 "Constrained Scrolling" "Constrained scrolling clamps the last line of text to the bottom of the text widget."] \
        [list widgetText(scrollContext) textContextLines NUM 2 "Scroll Context" "Scroll context is the number of lines that pages overlap when paging up and down through text."] \
        [list widgetText(selectDelay) textSelectDelay NUM 50 "Scroll/Select Time Constant" "When you drag a selection off the top or bottom of a text widget, the widget automatically scrolls and extends the selection.  This parameter is a polling time period that affects the behavior.  Too big and it is not responsive enough.  Too small and it may consume too many cycles.  Units are milliseconds."] \
        [list gui_flags(placeToplevel)  placeToplevel BOOL 1    {Remember window placement} "With this enabled, $gui_flags(title) will remember the placement of the various popup windows between sessions.  This means you can position them once manually and they will always appear there.  However, if you use a virtual root window manager and run $gui_flags(title) in different \"rooms\"then a remembered placement might be in the wrong room.  You can nuke all the placement memory from the end of the .tkhol-defaults file and always run $gui_flags(title) from the same room, or just disable this feature.."] \
        [list gui_flags(saveOnExit)     saveOnExit BOOL 0       {Save options on exit} ""] \
    ]
    


    Preferences_Add "General Fonts" "Fonts for buttons, lists and labels may be specified below.  Changes to these values generally only take effect after you restart $gui_flags(title)." [list \
        [list gui_flags(font,labels) Label.font FONT -Adobe-Helvetica-Bold-R-Normal-*-*-100-* "Labels" "The normal font used for labels."] \
        [list gui_flags(font,menus) [list Menubutton.font Menu.font] FONT -Adobe-Helvetica-Bold-R-Normal-*-*-100-* "Menus" "The normal font used for menus."] \
        [list gui_flags(font,buttons) [list Button.font Checkbutton.font Radiobutton.font] FONT -Adobe-Helvetica-Bold-R-Normal-*-*-100-* "Buttons" "The normal font used for buttons."] \
        [list gui_flags(font,bbar_buttons) buttonBarFont FONT -Adobe-Helvetica-Medium-R-Normal-*-*-100-* "Buttons" "The font used for buttons on button bars."] \
        [list gui_flags(font,feedback) feedbackFont FONT -Adobe-Helvetica-Bold-R-Normal-*-*-100-* "Feedback" "The normal font used for the feedback line."] \
        [list gui_flags(font,listboxes) Listbox.font FONT -Adobe-Helvetica-Medium-R-Normal-*-*-100-* "Lists" "The normal font used to display lists of items."] \
        [list gui_flags(font,textentry) textEntryFont FONT -Adobe-Helvetica-Medium-R-Normal-*-*-100-* "Text Entry" "The normal font used for entry and text widgets."] \
        [list gui_flags(font,codeentry) codeEntryFont FONT -Adobe-Courier-Medium-R-Normal-*-*-120-* "Code Entry" "The normal font used for widgets where code is entered."] \
        [list gui_flags(font,helptext) helpTextFont FONT -Adobe-Helvetica-Medium-R-Normal-*-*-100-* "Help Text" "The normal font used for help text"] \
    ]
    

}


#-------------------------------------------------------------------
# replacement tk_bindForTraversal since key is now configureable
# Have to make sure the old version is loaded in, then we override
# immediately.
#-------------------------------------------------------------------

auto_load tk_menuBar
proc tk_bindForTraversal args {
    global gui_flags
    foreach w $args {
        if [info exists gui_flags(menuTriggerModifiers)] {
            bind $w <$gui_flags(menuTriggerModifiers)-KeyPress> {tk_traverseToMenu %W %A}
        }
        bind $w <F10> {tk_firstMenu %W}
    }
}
tk_bindForTraversal Text Button Entry

#-------------------------------------------------------------------
#-------------------------------------------------------------------

proc PreferencesReadFile { basename level } {
    if [file exists $basename] {
        # puts "reading $basename"
        if [catch {option readfile $basename $level} err] {
            errormessage .error "Error in $basename: $err"
        }
    }
    if {[winfo depth .] > 1} {
        if [file exists $basename-color] {
        # puts "reading $basename-color"
            if [catch {option readfile $basename-color $level} err] {
                errormessage .error "Error in $basename-color: $err"
            }
        }
    } else {
        if [file exists $basename-mono] {
            if [catch {option readfile $basename-mono $level} err] {
                errormessage .error "Error in $basename-mono: $err"
            }
        }
    }
}
proc preferences::ShutdownPackage {  } {
    global gui_flags
    if $gui_flags(saveOnExit) {
        puts "Saving preferences..."
        PreferencesSave
    }
}


proc Preferences_Add { id text prefs } {
    global pref

    # Set up the table that drives the UI layout
    set ix [lsearch $pref(panes) $id]
    if {$ix < 0} {
        lappend pref(panes) $id
        set pref($id,prefs) $prefs
        set pref($id,text) $text
    } else {
        eval lappend pref($id,prefs) $prefs
        append pref($id,text) \n$text
    }

    # Initialize the global variable from the option database,
    # else the default value supplied.

    foreach item $prefs {
        set varName [PrefVar $item]
        set xresources [PrefXres $item]
        set type [PrefType $item]
        set default [PrefDefault $item]
        if {[lindex $xresources 0] == "FILE"} {
            if [catch {set f [open ~/[lindex $xresources 1]]}] {
                set value [PrefDefault $item]
            } {
                set value [read $f]
                close $f
            }
        } else {
            if [catch {set value [PrefValue $item]}] {
                # Try the option database
                set value [option get . [lindex $xresources 0] {}]
                if {$value=={}} {
                    # Set variables that are still not set
                   set value $default
                }
            } 
        }
        set type [PrefType $item]
        if {$type == "BOOL"} {
            case $value {
                    {0 1} { # ok as is }
                    {true True TRUE} { set value 1 }
                    {false False FALSE} { set value 0 }
                    default {
                        catch {puts stderr "Bogus boolean value $value for Xresource [lindex $xresources 0]"}
                        set value 0
                    }
            }
        }
        PrefValueSet $item $value
    }
}
# Return the value of the given variable,
# or {} if it doesn't exist
proc PrefValue { item } {
    set varname [PrefVar $item] 
    upvar #0 $varname var
    return $var
}


# Return the default value, either from the X database/persistent
# file store, or the default specified when the option was
# registered.
proc PrefResetValue { item } {
    set value [PrefDefault $item] 
    PrefValueSet $item $value
}

# set the value of the variable.  Adjust it's entry if its got one.
proc PrefValueSet { item value {priority interactive} } {
    global pref
    set varname [PrefVar $item] 
    upvar #0 $varname var
    set var $value
    if {[info exists pref(entry,$varname)] && [llength [info commands $pref(entry,$varname)]] >= 1} {
        $pref(entry,$varname) delete 0 end
        $pref(entry,$varname) insert 0 $value
    }
    set xresources [PrefXres $item]
    foreach xresource $xresources {
        # puts "option add *$xresource $value $priority"
        option add *$xresource $value $priority
    }
}


# set the value of the variable from what is given in it's entry
proc PrefEntrySet { entry item } {
    PrefValueSet $item [$entry get]
}

proc preferences::groups { } {
        global pref
        return [lsort $pref(panes)]
}

proc PreferencesRecordEntryChanges { id } {
    global pref
    foreach item $pref($id,prefs) {
        set varname [PrefVar $item]
        if {[info exists pref(entry,$varname)] && [llength [info commands $pref(entry,$varname)]] >= 1} {
            PrefValueSet $item [$pref(entry,$varname) get]
        }
    }
}


proc PreferencesSave { {id_in {}} } {
    global pref
    global busy
    if [info exists busy] { incr busy }
    if {$id_in == {}} {
        set id_in $pref(panes)
    } else {
        set id_in [list $id_in]
    }
    foreach id $id_in {
        set newstuff {}
        foreach item $pref($id,prefs) {
            set varname [PrefVar $item]
            set xresources [PrefXres $item]
            set type [PrefType $item]
            set default [PrefDefault $item]
            if ![regexp ^(INTERFACE_MAP)\$ $type] {
                set value [PrefValue $item]
                if {$value!=$default} {
                    if  {[lindex $xresources 0] == "FILE"} {
                        if [catch {set f [open ~/[lindex $xresources 1] w]} err] {
                            puts stderr "warning: could not open [lindex $xresources 1] for writing: $err"
                        } {
                            puts -nonewline $f $value
                            close $f
                        }
                    } else {
                        lappend newstuff [format "%s\t%s" *${xresources}: $value]
                    }
                }
            }
        }
        Preferences_RewriteSection "$id options." "End $id options." $newstuff
    }
    if [info exists busy] { incr busy -1 }
    # PreferencesReset
}
proc Preferences_RewriteSection { boundary1 boundary2 newstuff } {
    global pref
    if [catch {
        set old [open $pref(userDefaults) r]
        set oldValues [split [string trimright [read $old] \n] \n]
        close $old
    }] {
        set oldValues {}
    }
    if [catch {open $pref(userDefaults).new w} out] {
        errormessage .error "Cannot save in $pref(userDefaults).new: $out" warn
        return
    }
    set state "before"
    foreach line $oldValues {
        case $state {
            "before" {
                if {[string compare $line "!!! $boundary1"] == 0} {
                    set state "inside"
                    puts $out ""
                    puts $out "!!! $boundary1"
                    foreach item $newstuff {
                        puts $out $item
                    }
                    puts $out "!!! $boundary2"
                } else {
                    puts $out $line
                }
            }
            "inside" {
                if {[string compare $line "!!! $boundary2"] == 0} {
                    set state "after"
                }
            }
            "after" {
                puts $out $line
            }
        }
    }
    if {$state == "before"} {
        puts $out ""
        puts $out "!!! $boundary1"
        foreach item $newstuff {
            puts $out $item
        }
        puts $out "!!! $boundary2"
    }
    close $out
    set new [glob $pref(userDefaults).new]
    set old [file root $new]
    if [catch {exec mv $new $old} err] {
        errormessage .error "Cannot install $new: $err"
        return
    }
}
proc Preferences_ReadSection { boundary1 boundary2 } {
    global pref
    if [catch {
        set old [open $pref(userDefaults) r]
        set oldValues [split [string trimright [read $old] \n] \n]
        close $old
    }] {
        set oldValues {}
    }
    set state "before"
    set results {}
    foreach line $oldValues {
        case $state {
            "before" {
                if {[string compare $line "!!! $boundary1"] == 0} {
                    set state "inside"
                }
            }
            "inside" {
                if {![regexp {^!!!} $line]} {
                    lappend results $line
                }
                if {[string compare $line "!!! $boundary2"] == 0} {
                    break
                }
            }
        }
    }
    return $results
}
proc PreferencesReset { {id_in {}} } {
    global pref

# Re-read user defaults.  Don't clear the option database since
# so many widget defaults are stored there!!
#    option clear

    PreferencesReadFile $pref(userDefaults) user
    # Now set variables
    if {$id_in == {}} {
        set id_in $pref(panes)
    } else {
        set id_in [list $id_in]
    }
    foreach id $id_in {
        foreach item $pref($id,prefs) {
            PrefResetValue $item
        }
    }
}

