#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




option add *Collapsible.visible 0 widgetDefault
option add *Collapsible.title {} widgetDefault
option add *Collapsible.collapseCommand {} widgetDefault
option add *Collapsible.a.relief flat widgetDefault

proc collapsible args {
        global collapsible_priv

        global gui_flags


        set argc [llength $args]
        set afterw 0
        set widget ""
        set configs ""
        for {set i 0} {$i < $argc} {incr i} {
            set arg [lindex $args $i]
            if $afterw {
                switch -- $arg -title {
                    incr i
                    set title [lindex $args $i]
                } -visible {
                    incr i
                    set visible [lindex $args $i]
                } -collapseCommand {
                    incr i
                    set collapseCommand [lindex $args $i]
                } default {
                    lappend configs $arg
                    incr i
                    lappend configs [lindex $args $i]
                } 
            } else {
                if [regexp {^\.} $arg] {
                    set w $arg
                    set afterw 1
                } else {
                    lappend widget [lindex $args $i]
                }
            }
        }
        if ![info exists w] { error "Couldn't find window name in arguments" }
        frame $w -class Collapsible

        if ![info exists title] { set title [option get $w title Title] }
        if ![info exists visible] { set visible [option get $w visible Visible] }
        if ![info exists collapseCommand] { set collapseCommand [option get $w collapseCommand CollapseCommand] }


        set collapsible_priv(visible,$w) $visible
        set collapsible_priv(collapseCommand,$w) $collapseCommand

        pack [button $w.a \
                        -command "collapsible_toggle $w" \
                        -borderwidth 0 \
                        -bitmap [icon_find triangler]] \
                -side left -anchor n
        pack [fontcheck label $w.t \
                -text $title] \
            -side top -anchor w

        eval $widget $w.b $configs

        bind $w.a <FocusIn> "collapsible:focusIn.a $w.a"
        bind $w.a <FocusOut> "collapsible:focusOut.a $w.a"

        if {$visible} {
                collapsible_show $w
        }
        return $w
}



proc collapsible_toggle w {
        global collapsible_priv
        if {$collapsible_priv(visible,$w)} {
                collapsible_hide $w
        } else {
                collapsible_show $w
        }
}

proc collapsible_hide w {
        global collapsible_priv
        set collapsible_priv(visible,$w) 0
        if {[string compare $w.a [focus]] == 0} {
                $w.a config -bitmap [icon_find filltriangler]
        } else {
                $w.a config -bitmap [icon_find triangler]
        }
        if {$collapsible_priv(collapseCommand,$w) != ""} {
            eval $collapsible_priv(collapseCommand,$w) 0
        }
        pack forget $w.b
        # NOTE: Need to defocus any descendant of $w.b!
        
        
}

proc collapsible_show w {
        global collapsible_priv
        set collapsible_priv(visible,$w) 1
        if {[string compare $w.a [focus]] == 0} {
                $w.a config -bitmap [icon_find filltriangled]
        } else {
                $w.a config -bitmap [icon_find triangled]
        }
        if {$collapsible_priv(collapseCommand,$w) != ""} {
            eval $collapsible_priv(collapseCommand,$w) 1
        }
        pack $w.b -side top -expand yes -fill both
}


proc collapsible:focusIn.a w {
        set b [lindex [$w config -bitmap] 4]
        $w config -bitmap [file dirname $b]/fill[file tail $b]
}


proc collapsible:focusOut.a w {
        set b [lindex [$w config -bitmap] 4]
        $w config -bitmap \
                [file dirname $b]/[string range [file tail $b] 4 end]
}


