#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc choicebox {w args} {
        set fargs {}
        set text {}
        set icon {}
        set buttons {}
        set textvariable $w
        while {[llength $args] >= 2} {
                set option [lindex $args 0]
                set value [lindex $args 1]
                set args [lrange $args 2 end]
                case $option in {
                        -text { set text $value }
                        -icon { set icon $value }
                        -buttons { set buttons $value }
                        -textvariable { set textvariable $value }
                        default {
                                lappend fargs $option $value
                        }
                }
        }
        if {$args != ""} {
                error "choicebox: extraneous argument $args"
        }
        eval frame $w -class Choicebox $fargs
        pack [choicebox:buttons $w.b \
                        -buttons $buttons \
                        -textvariable $textvariable] \
            -side bottom -expand yes -fill both
        if {$text != ""} {
                global gui_flags
                pack [fontcheck message $w.m \
                        -text $text \
                        -width 400 \
                        -font $gui_flags(font,feedback)] \
                    -side right -expand yes -fill both
        }
        if {$icon != ""} {
                pack [icon $w.i -icon $icon] -fill both
        }
        return $w
}

# Procedure: choicebox:buttons
#
# Synopsis:
#       Make the push-button panel for a choicebox.
#
# Usage:
#c      choicebox:buttons pathName ?-option value...?
#
# Parameters:
#c      pathName
#               Path name of the button box widget
#
# Options:
#c      -buttons {b1 b2 b3}
#               List of button text, or button text - variable value pairs
#
#c      -textvariable v
#               Variable name in which to store the button value.
#
#       Other options as for frame.
#
# Return value:
#       Name of the button box widget.
#
# Description:
#       choicebox:buttons is an internal procedure used by the choicebox
#       procedure to fabricate the array of push buttons that appear at
#       the bottom of a choicebox.

proc choicebox:buttons {w args} {
        set fargs {}
        set textvariable $w
        set buttons {}
        while {[llength $args] >= 2} {
                set option [lindex $args 0]
                set value [lindex $args 1]
                set args [lrange $args 2 end]
                case $option in {
                        -buttons { set buttons $value }
                        -textvariable { set textvariable $value }
                        default {
                                lappend fargs $option $value
                        }
                }
        }
        if {$args != ""} {
                error "choicebox:buttons: extraneous argument $args"
        }
        eval frame $w $fargs
        set bnum 0
        foreach b $buttons {
                incr bnum
                if {[llength $b] > 1} {
                        set bval [lindex $b 1]
                } else {
                        set bval [lindex $b 0]
                }
                global gui_flags
                pack [fontcheck button $w.b$bnum \
                                -text [lindex $b 0] \
                                -command "set $textvariable $bval"] \
                    -side left -expand yes -padx 10 -pady 10
        }
        after 1 [list focus $w.b1]
        return $w
        
}


proc choice { w args } {
        global choicePriv
        catch {unset choicePriv}
        eval [list modalDialog transient choicebox $w] \
            [list -withfeedback 0 \
            -icon think \
            -buttons [list Yes No Cancel]] \
            $args \
            [list -textvariable choicePriv]
        wm protocol [winfo toplevel [winfo parent $w]] WM_DELETE_WINDOW "set choice {}"
        tkwait variable choicePriv
        modalDialog.end $w
        return $choicePriv
}

