#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




# for autoloading 
proc combobox { } { }

composite_define [list ComboBox Colors] {
     {-anchor anchor Anchor w composite_configPrivateNop}
     {-command command Command {} composite_configPrivateNop}
     {-type type Type static composite_configPrivateNop}
     {-histlimit histLimit HistLimit 20 composite_configPrivateNop}
     {-fancy fancy Fancy "false" composite_configPrivateNop}
     {-scrollbar scrollbar Scrollbar y composite_configPrivateNop}
     {-disabledforeground disabledForeground DisabledForeground #606060 composite_configPrivateNop}
     {-entrywidth entryWidth EntryWidth 10 composite_configPrivateNop}
     {-entryfont entryFont Font "-adobe-helvetica-medium-r-normal-*-*-120-*-*-*-*-*-*" composite_configPrivateNop}
     {-entrybg entryBg EntryBg #ffe4c4 composite_configPrivateNop}
     {-listboxbg listboxBg ListbixBg #ffe4c4 composite_configPrivateNop}
     {-listboxfont listboxFont Font "-adobe-helvetica-medium-r-normal-*-*-120-*-*-*-*-*-*" composite_configPrivateNop}
     {-listboxheight listboxHeight ListboxHeight 6 composite_configPrivateNop}

     {-state state State normal composite_configPrivateNop}
} combobox::initProc

proc combobox::initProc {w} {
    upvar #0 $w data
    upvar #0 config$w config
    global combobox_library

    set data(grabbed)      0
    set data(first_expose) 0
    set data(flag)         0
    set data(histCount)    0

    if {$config(type) == "history" || $config(type) == "editable"} {
        set data(editable) 1
    } else {
        set data(editable) 0
    }

    # Create the static part of the combo box
    #----------------------------------------
    set data(entry) [entry $w.ent \
                     -width $config(entryWidth) -font $config(entryFont)]
    set data(cross) [button $w.cross -bitmap @$combobox_library/bitmaps/cross]
    set data(tick)  [button $w.tick  -bitmap @$combobox_library/bitmaps/tick]
    set data(btn)   [button $w.btn -bitmap @$combobox_library/bitmaps/cbxarrow]

    if {$config(fancy) == "true" || $config(fancy) == "yes"} {
        pack $w.cross -side left -padx 1
        pack $w.tick  -side left -padx 1
    }
    pack $w.btn -side right -padx 1
    pack $w.ent -side left -fill x -expand yes -padx 1

    # Create the shell and the list
    #------------------------------

    set data(shell) [toplevel $w.shell -border 2 -relief raised -cursor arrow]
    wm overrideredirect $w.shell 1
    wm withdraw $w.shell

#        -scrollbar $config(scrollbar)
#        -anchor $config(anchor)

    set data(slb) \
        [scrollable listbox $w.shell.slb \
         -bg $config(listboxBg)\
         -font $config(listboxFont)]

    pack $data(slb) -expand yes -fill both


    # Set the behavior of the combobox
    #---------------------------------

    bind $data(entry) <Down>     "combobox::EntArrowKeyDown $w ; break"
    bind $data(entry) <Up>       "combobox::EntArrowKeyUp   $w ; break"
    bind $data(entry) <Return>   "combobox::EntReturn $w ; break"
    bind $data(entry) <Double-ButtonPress-1> "combobox::EntReturn $w ; break"
    bind $data(entry) <1>        "+focus %W ; break"
    bind $data(entry) <1>        "+[bind Entry <1>] ; break"
    global tix_priv
    if [info exists tix_priv(as_loaded)] {
        tixAutoS_BindEntry $data(entry)
    }

    bind [$data(slb) listbox] <Down>      "combobox::LbArrowKeyDown $w ; break"
    bind [$data(slb) listbox] <Up>        "combobox::LbArrowKeyUp   $w ; break"
    bind [$data(slb) listbox] <Return>    "combobox::LbReturn $w ; break"

    bind [$data(slb) listbox] <B1-Motion> "combobox::LbButton $w %y ; break"
    bind [$data(slb) listbox] <1>         "combobox::LbButton $w %y ; break"
    bind [$data(slb) listbox] <ButtonRelease-1> "combobox::LbRelease $w %x %y ; break"
    if [info exists tix_priv(as_loaded)] {
        tixAutoS_BindListboxSingle [$data(slb) listbox]
    }

    # Note that <1> is treated the same as escape if it happens
    # outsides of the combobox
    bind [$data(slb) listbox] <Escape> "combobox::EscKey $w ; break"
    bind $data(entry)   <Escape> "combobox::EscKey $w ; break"
    bind $data(btn)     <Escape> "combobox::EscKey $w ; break"
    bind $w             <Escape> "combobox::EscKey $w ; break"
    bind $w             <1>      "combobox::EscKey $w ; break"


    $data(btn)   config -command "combobox::BtnUp $w"
    $data(tick)  config -command "combobox::EntReturn $w"
    $data(cross) config -command "combobox::ClearEntry $w"

#    if {$data(editable) != "1"} {
#       global tixOption
#       $data(entry) config -bg $tixOption(bg)
#    }
}


proc combobox::SetBindings {w} {
    upvar #0 $w data
    upvar #0 config$w config

    bind $w <Expose> "combobox::Expose $w ; break"
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------

composite_configFlag ComboBox anchor {w flag arg} {
    # $$temp not implemented
    return private
}

composite_configFlag ComboBox entryBg {w flag arg} {
    upvar #0 $w data
    upvar #0 config$w config

    $data(entry) config -bg $arg
    return private
}

composite_configFlag ComboBox entryFont {w flag arg} {
    upvar #0 $w data
    upvar #0 config$w config

    $data(entry) config -font $arg
    return private
}

composite_configFlag ComboBox entryWidth { w flag arg } {
    upvar #0 $w data
    upvar #0 config$w config
    $data(entry) config -width $arg
    return private
}

composite_configFlag ComboBox listboxBg {w flag arg} {
    upvar #0 $w data
    upvar #0 config$w config

    $data(slb) listbox config -bg $arg
    return private
}

composite_configFlag ComboBox listboxFont {w flag arg} {
    upvar #0 $w data
    upvar #0 config$w config

    $data(slb) listbox config -font $arg
    return private
}

composite_configFlag ComboBox listboxHeight {w flag arg} {
    upvar #0 $w data
    upvar #0 config$w config

    $data(slb) listbox config -width $config(entryWidth) -height $config(listboxHeight)
    return private
}


#----------------------------------------------------------------------
#                     WIDGET COMMANDS
#----------------------------------------------------------------------
composite_subcommand ComboBox listbox {w args} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$args != {}} {
        return [eval $data(slb) listbox $args]
    } else {
        return [$data(slb) listbox]
    }
}

composite_subcommand ComboBox entry {w args} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$args == {}} {
        return $data(entry)
    } elseif {[lindex $args 0] == "set"} {
        if {$data(editable) == "0"} {
            $data(entry) config -state normal
        }
        $data(entry) delete 0 end
        $data(entry) insert 0 [lindex $args 1]
        if {$data(editable) == "0"} {
            $data(entry) config -state disabled
        }
        if {$config(anchor) == "e"} {
            combobox::EntryAlignEnd $w
        }
    } else {
        return [eval $data(entry) $args]
    }
}

composite_subcommand ComboBox pick {w args} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$data(editable) == "0"} {
        $data(entry) config -state normal
    }
    if {[llength $args] == "2"} {
        set index [lindex $args 1]
        $data(slb) listbox select set $index $index
        $data(slb) listbox select set $index $index
        set text [$data(slb) listbox get $index]
    } else {
        set text [lindex $args 0]
    }
    $data(entry) delete 0 end
    $data(entry) insert 0 $text

    #kludge : if pick before exposing, picked item will be lost

    if {$data(first_expose) == "1"} {
        set data(first_expose) 0
    }
    if {$data(editable) == "0"} {
        $data(entry) config -state disabled
    }
}

composite_subcommand ComboBox addhistory {w newtext} {
    upvar #0 $w data
    upvar #0 config$w config

    set indices [$data(slb) listbox curselection]
    if {$indices == "" } {
        set i 0
    } else {
        set i [lindex $indices 0]
    }
    set newtext [string trim $newtext]
    if {$newtext != ""} {
        $data(slb) listbox insert $i $newtext
        $data(slb) listbox select clear 0 end
        $data(slb) listbox select set $i $i
    }
    if {$data(histCount) == $config(histLimit)} {
        $data(slb) listbox delete end
    } else {
        incr data(histCount)
    }
}

composite_subcommand ComboBox appendhistory {w newtext} {
    upvar #0 $w data
    upvar #0 config$w config

    $data(slb) listbox insert end $newtext
    if {$data(histCount) == $config(histLimit)} {
        $data(slb) listbox delete 0
    } else {
        incr data(histCount)
    }
}

composite_subcommand ComboBox align {w} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$config(anchor) == "e"} {
        combobox::EntryAlignEnd $w
    }
}

composite_subcommand ComboBox get {w} {
    upvar #0 $w data
    upvar #0 config$w config

    return [$data(entry) get]
}

#----------------------------------------------------------------------
#                   E V E N T   B I N D I N G S
#----------------------------------------------------------------------
proc combobox::BtnUp {w} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$data(grabbed) == 0} {
        combobox::PopupShell $w
    } else {
        combobox::RestoreValue $w
        combobox::PopdownShell $w
    }
}

proc combobox::EntArrowKeyUp {w} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$data(grabbed) == 0} {
        combobox::PopupShell $w
        combobox::SetEntry $w
    } else {
        combobox::LbArrowKeyUp $w
    }
}

proc combobox::EntArrowKeyDown {w} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$data(grabbed) == 0} {
        combobox::PopupShell $w
        combobox::SetEntry $w
    } else {
        combobox::LbArrowKeyDown $w
    }
}

proc combobox::EntReturn {w} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$data(grabbed) != 0} {
        combobox::PopdownShell $w
    }

    set old_bg [lindex [$data(entry) config -bg] 4]
    set old_fg [lindex [$data(entry) config -fg] 4]
    $data(entry) config -fg $old_bg
    $data(entry) config -bg $old_fg
    update idletasks
    $data(entry) config -fg $old_fg
    $data(entry) config -bg $old_bg

    if {$config(command) != {} && $config(command) != "" } {
        eval $config(command) [list [$data(entry) get]]
    }

    if {$config(type) == "history"} {
        combobox::addhistory $w [$data(entry) get]
    }
}

proc combobox::LbButton {w y} {
    upvar #0 $w data
    upvar #0 config$w config
    $data(slb) listbox select clear 0 end
    $data(slb) listbox select set [$data(slb) listbox nearest $y]
    combobox::SetEntry $w
}

proc combobox::LbReturn {w} {
    upvar #0 $w data
    upvar #0 config$w config

    combobox::PopdownShell $w
    if {$config(command) != {} && $config(command) != "" } {
        eval $config(command) [list [$data(entry) get]]
    }
}

proc combobox::LbRelease {w x y} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$x < 0 || $y < 0} {
        return
    }
    set listbox [$data(slb) listbox]
    if {$x > [winfo width $listbox]} {
        return
    }
    if {$y > [winfo height $listbox]} {
        return
    }

    combobox::PopdownShell $w
    if {$config(command) != {} && $config(command) != "" } {
        eval $config(command) [list [$data(entry) get]]
    }
}


proc combobox::LbArrowKeyUp {w} {
    upvar #0 $w data
    upvar #0 config$w config

    set indices [$data(slb) listbox curselection]
    if {$indices == "" } {
        $data(slb) listbox select clear 0 end
        $data(slb) listbox select set   0 0
        $data(slb) listbox yview 0
    } else {
        set i [lindex $indices 0]
        if {$i > 0} {
            incr i -1
            $data(slb) listbox select clear 0 end
            $data(slb) listbox select set $i $i
            set height [$data(slb) info height]
            set yview  [$data(slb) info yview]
            if {$i < $yview || $i >= [expr "$yview+$height"]} {
                $data(slb) listbox yview $i
            }
        }
    }
    combobox::SetEntry $w
}


proc combobox::LbArrowKeyDown {w} {
    upvar #0 $w data
    upvar #0 config$w config

    set indices [$data(slb) listbox curselection]
    if {$indices == "" } {
        $data(slb) listbox select clear 0 end
        $data(slb) listbox select set  0
        $data(slb) listbox yview 0
    } else {
        set i [lindex $indices 0]
        incr i
        if {$i < [$data(slb) info totalheight]} {
            $data(slb) listbox select clear 0 end
            $data(slb) listbox select set $i
            set height [$data(slb) info height]
            set yview  [$data(slb) info yview]
            if {$i < $yview || $i >= [expr "$yview+$height"]} {
                $data(slb) listbox yview [expr "$i - $height + 1"]
            }
        }
    }
    combobox::SetEntry $w
}

proc combobox::EscKey {w} {
    upvar #0 $w data
    upvar #0 config$w config
    
    if {$data(grabbed) == "1"} {
        combobox::RestoreValue $w
        combobox::PopdownShell $w
    }
}

proc combobox::Expose {w} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$data(first_expose) == "1"} {
        set data(first_expose) 0
        combobox::SetEntry $w
    }
}

#----------------------------------------------------------------------
# Internal commands
#----------------------------------------------------------------------
proc combobox::SetEntry {w} {
    upvar #0 $w data
    upvar #0 config$w config

    set indices [$data(slb) listbox curselection]
    if {$indices != ""} {
        set i [lindex $indices 0]
    } else {
        set i 0
    }
    if {$data(editable) == "0"} {
        $data(entry) config -state normal
    }
    $data(entry) delete 0 end
    $data(entry) insert 0 [$data(slb) listbox get $i]
    if {$data(editable) == "0"} {
        $data(entry) config -state disabled
    }
    focus $data(entry)
}

proc combobox::ClearEntry {w} {
    upvar #0 $w data
    upvar #0 config$w config

    $data(entry) delete 0 end
}

proc combobox::PopdownShell {w} {
    upvar #0 $w data
    upvar #0 config$w config

    wm withdraw $data(shell)
    focus $data(entry)
    $w config -cursor {}
    grab release $w
    set data(grabbed) 0
}

proc combobox::RestoreValue {w} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$data(editable) == "0"} {
        $data(entry) config -state normal
    }
    $data(entry) delete 0 end
    $data(entry) insert 0 $data(oldvalue)
    if {$data(editable) == "0"} {
        $data(entry) config -state disabled
    }
}

# Calculating the geometry of the combo box
#
# +4 in the height because of the frames surrounding the listbox
proc combobox::PopupShell {w} {
    upvar #0 $w data
    upvar #0 config$w config

    # pop up the shell
    set y [expr [winfo rooty $data(entry)]+[winfo height $data(entry)]+3]
    $data(slb) config -width $config(entryWidth) -height $config(listboxHeight)
    set height [expr "[winfo reqheight [$data(slb) listbox]]+4"]

    set x1 [winfo rootx $data(entry)]
    set x2 [expr "[winfo rootx $data(btn)] + [winfo width $data(btn)]"]
    set width  [expr "$x2 - $x1"]

    # If the listbox is below bottom of screen, put it upwards
    set scrheight [winfo screenheight .]
    set bottom [expr $y+$height]
    if {$bottom > $scrheight} {
        set y [expr $y-$height-[winfo height $data(entry)]-5]
    }

    wm geometry $data(shell) $width\x$height+$x1+$y
    wm deiconify $data(shell)
    raise $data(shell)
    focus $data(entry)

    if {[$data(slb) listbox curselection] == ""} {
        $data(slb) listbox select clear 0 end
        $data(slb) listbox select set 0
    }
    $w config -cursor arrow

    set data(grabbed) 1
    set data(oldvalue) [$data(entry) get]
    catch {
        grab -global $w
    }
}

# The following two routines can emulate a "right align mode" for the
# entry in the combo box.
proc combobox::MonitorEntry {w total max begin end} {
    upvar #0 $w data
    upvar #0 config$w config

    if {$data(flag) == 0} {
        set data(flag) 1
        if {$total > $max && $total > [expr $end +1]} {
            $data(entry) view [expr "$total - $max + 1"]
        }
        set data(flag) 0
    }
}

proc combobox::EntryAlignEnd {w} {
    upvar #0 $w data
    upvar #0 config$w config

    set data(flag) 0
    $data(entry) config \
        -scroll "combobox::MonitorEntry $w"
    update idletasks
    $data(entry) config -scroll {}
}

