#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




# for autoloading...
proc richtextobjects {} {}

composite_define RichTextObjects {
        {-showlistbox showListbox ShowListbox 1 composite_configPrivateNop}
        {-showbuttonbar showButtonbar ShowButtonbar 1 composite_configPrivateNop}
        {-selectioncommand selectionCommand Command nop composite_configPrivateNop}
        {-selectionvar selectionVar Command rtoselection composite_configPrivateNop}
} RichTextObjects::initProc

proc RichTextObjects::initProc { w args } {
        upvar #0 config$w config
        upvar #0 $w data
        global gui_flags
        global TheoremWidgets_library
        set data(displayed_objects) ""
        
        pack [frame $w.box] -side left -fill y

        buttonbar $w.box.buttonbar \
                -orient vertical
        if $config(showButtonbar) {
            pack $w.box.buttonbar  -side left -fill y
        }
                                           
        scrollable selectlistbox $w.box.listbox \
                -relief sunken \
                -export false \
                -setgrid 1 \
                -selectionvar [set w](selection)

        if $config(showListbox) {
            pack $w.box.listbox -side right -fill y
        }

        # what a horrible piece of code this next bit is...
        # The second line of the trace looks up the current
        # value of the selectionComand and executes it.  
        # trace_ignore throws away the stupid extra arguments
        # used by the trace command.
        # The third line sets the current selection var (different
        # to the listbox's selection var) to the current value
        # of the selection.
        trace variable data(selection) w "
            trace_ignore \{
                $w expandselection;
                eval \[set config[set w](selectionCommand)\]
                set \[set config[set w](selectionVar)\] \[$w selection\]
            \}"

        # Nb. Creating the RichText frame also sets initial default
        # values for the three variables.

        pack [richtext $w.richtext] -expand yes -fill both -side right
        
        if $gui_flags(debug) { puts "Leaving RichTextObjects"}
        return $w
}

#----------------------------------------------------------------------------
# Widget commands
#
#----------------------------------------------------------------------------

composite_configFlag RichTextObjects showListbox { w arg value } {
        upvar #0 config$w config
        if $value {
            pack $w.box -side left -fill y
            pack $w.box.listbox -side right -fill y
        } else {
            pack forget $w.box.listbox
            if !$config(showButtonbar) { pack forget $w.box }
        }
        return private
}

composite_configFlag RichTextObjects showButtonbar { w arg value } {
        upvar #0 config$w config
        if $value {
            pack $w.box -side left -fill y
            pack $w.box.buttonbar -side left -fill y
        } else {
            pack forget $w.box.buttonbar
            if !$config(showListbox) { pack forget $w.box }
        }
        return private
}


composite_subcommand RichTextObjects listbox { w args } {
        if {[llength $args] > 0} {
            eval $w.box.listbox.b $args
        } else {
            return [$w.box.listbox selectlistbox]
        }
}

composite_subcommand RichTextObjects buttonbar { w args } {
        if {[llength $args] > 0} {
            eval $w.box.buttonbar $args
        } else {
            return $w.box.buttonbar]
        }
}

composite_subcommand RichTextObjects richtext { w args } {
        if {[llength $args] > 0} {
            eval $w.richtext $args
        } else {
            return $w.richtext
        }
}


composite_subcommand RichTextObjects getobject { w args } {
        eval $w.richtext getobject $args
}


composite_subcommand RichTextObjects addobjects { w args } {
        upvar #0 $w data
        set listbox [$w.box.listbox selectlistbox]
        foreach obj_name_spec_pair $args {
            set name [lindex $obj_name_spec_pair 0]
            set objspec [lindex $obj_name_spec_pair 1]
            set size [$w.box.listbox selectlistbox size]
            set inserted 0
            for {set i 0} {$i < $size} {incr i} {
                if {[$listbox get $i] > $name} {
                    $listbox insert $i $name
                    set inserted 1
                    break
                }
            }
            if {!$inserted} {
                $listbox insert end $name
            }
            $listbox yview [expr $i-2]
            set data(objs,$name) $objspec
            selectlistbox::clear_selection [$w.box.listbox selectlistbox]
        }
}


composite_subcommand RichTextObjects setobjects { w args } {
        upvar #0 $w data
        $w.box.listbox selectlistbox delete 0 end
        $w.richtext deleteall
        foreach name [array names data] {
            if [regexp \^.*,displayid\$ $name] {
                unset data($name)
            } 
            if [regexp \^objs,.*\$ $name] {
                unset data($name)
            }
        }
        set names ""
        foreach obj_name_spec_pair $args {
            set name [lindex $obj_name_spec_pair 0]
            set objspec [lindex $obj_name_spec_pair 1]
            lappend names $name
                # puts "objspec (A) = $objspec"
            set data(objs,$name) $objspec
        }
        eval [list $w.box.listbox selectlistbox insert end] $names
        selectlistbox::clear_selection [$w.box.listbox selectlistbox]
}



composite_subcommand RichTextObjects deleteobjects { w args } {
        upvar #0 $w data
        global busy
        incr busy
        foreach name $args {
            if [info exists data($name,displayid)] {
                $w.richtext deleteobject $data($name,displayid)
                unset data($name,displayid)
            }

            # search through the listbox for the object to delete

            set size [$w.box.listbox selectlistbox size]
            for {set i 0} {$i < $size} {incr i} {
                if {[$w.box.listbox selectlistbox get $i]==$name} {
                    $w.box.listbox selectlistbox delete $i
                    break
                }
            }
        }
        incr busy -1
}






#----------------------------------------------------------------------------
# RichTextObjectss::expand
#
#----------------------------------------------------------------------------


composite_subcommand RichTextObjects expand { w args } {
        global feedback
        foreach name $args {
            upvar #0 $w data
            set objspec $data(objs,$name)
            if {![info exists data($name,displayid)]} {
                set size [$w.box.listbox selectlistbox size]
                for {set i 0} {$i < $size} {incr i} {
                    set prev_name [$w.box.listbox selectlistbox get $i]
                    if {$name==$prev_name} { break }
                    if [info exists data($prev_name,displayid)] {
                        set prev_displayid $data($prev_name,displayid)
                    }
                }
                if {[info exists prev_displayid]} {                                                                          
                    set afterargs [list -after $prev_displayid]
                } else {
                    set afterargs ""
                }
                set data($name,displayid) [eval [list $w.richtext insertobject $objspec] $afterargs]
            } else {
                $w.richtext yviewobject $data($name,displayid)
            }

        }
#       incr busy -1
}

composite_subcommand RichTextObjects select { w args } {
        global vals
        upvar #0 $w data
        upvar #0 config$w config
        if {[lindex $args 0]=="all"} {
            selectlistbox::select [$w.box.listbox selectlistbox] 0 end
        } else {
            set selection_set ""
            foreach name $args {
                set size [$w.box.listbox selectlistbox size]
                for {set i 0} {$i < $size} {incr i} {
                    if {[$w.box.listbox selectlistbox get $i]==$name} {
                        lappend selection_set $i
                        break
                    }
                }
                eval [list selectlistbox::select [$w.box.listbox selectlistbox]] $selection_set
            }
        }
}

#----------------------------------------------------------------------------
# selection
#
# Returns the names of the selected objects
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects selection { w } {
        upvar #0 $w data
        set sel [$w.box.listbox selectlistbox curselection]
        set names ""
        foreach index $sel {
            set name [$w.box.listbox selectlistbox get $index]
            lappend names $name
        }
        return $names
}

composite_subcommand RichTextObjects objspec { w name } {
        upvar #0 $w data
        return $data(objs,name)
}

#args ignored - procedure is used as a trace routine
composite_subcommand RichTextObjects expandselection { w args } {
        global feedback
        upvar #0 $w data
        upvar #0 config$w config
        set selection [$w selection]
        eval [list $w expand] $selection
}


#----------------------------------------------------------------------------
# $w expandall
#
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects expandall { w } {
        upvar #0 $w data                     
        global busy
        incr busy
        set size [$w.box.listbox selectlistbox size]
        
        for {set i 0} {$i<$size} {incr i} {
            set name [$w.box.listbox selectlistbox get $i]
            if {$name==""} break
            set objspec [set data(objs,$name)]
            if {![info exists data($name,displayid)]} {
                if {[info exists prev_displayid]} {                                                                          
                    set afterargs [list -after $prev_displayid]
                } else {
                    set afterargs ""
                }
                set displayid [eval [list $w.richtext insertobject $objspec] $afterargs]
                set data($name,displayid) $displayid
                $w.richtext yviewobject $displayid
                update idletasks
            }
            set prev_displayid $data($name,displayid) 
        }
        if {$size>0} {
            $w.richtext yviewobject $data([$w.box.listbox selectlistbox get 0],displayid) 
        }
        incr busy -1
}

#----------------------------------------------------------------------------
# $w objects
#
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects objects { w } {
        upvar #0 $w data                     
        set size [$w.box.listbox selectlistbox size]
        set names ""
        for {set i 0} {$i<$size} {incr i} {
            set name [$w.box.listbox selectlistbox get $i]
            lappend names $name
        }
        return $names
}

#----------------------------------------------------------------------------
# $w objspec_for_object
#
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects objspec_for_object { w name } {
        upvar #0 $w data                     
        return $data(objs,$name)
}


#----------------------------------------------------------------------------
# $w reformatall
#
# args are ignored
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects reformatall { w args } {
    if [catch {
        upvar #0 $w data
        global busy
        incr busy
        $w.richtext deleteall
        set size [$w.box.listbox selectlistbox size]
        for {set i 0} {$i<$size} {incr i} {
            set name [$w.box.listbox selectlistbox get $i]
            set objspec [set data(objs,$name)]
            if {[info exists data($name,displayid)]} {
                if {[info exists prev_displayid]} {                                                                          
                    set afterargs [list -after $prev_displayid]
                } else {
                    set afterargs ""
                }
                set data($name,displayid) [eval [list $w.richtext insertobject $objspec] $afterargs]
                if ![info exists first] { set first $data($name,displayid) }
                set prev_displayid $data($name,displayid)
                $w.richtext yviewobject $data($name,displayid)
                update idletasks
            }
        }
        if [info exists first] {
            $w.richtext yviewobject $first
        }
        incr busy -1
    } err] { global errorInfo ; puts stderr "warning (RichtextObjects - reformatall: $errorInfo" ; raise $err $errorInfo  }
}


