#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc NewIndDef { w args } {
        global gui_flags 
        global NewIndDef_flags
        global feedback
        global busy
        incr busy
        global vals

        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i] -initial {
                incr i
                set initial [lindex $args $i]
            } default {
                error "unrecognized arg [lindex $args $i]"
            }
        }

        toplevel $w -class NewIndDef

        wm withdraw $w
        wm title $w "New Inductive Definition"
        
        set feedback [list {} "Creating NewIndDef display..."]
        

            #---------------

#       pack [collapsible frame $w.templ -title "Template:" -visible 1] \
#               -side top -fill both -padx 5 -pady 5
#       pack [fontcheck entry $w.templ.b.templ \
#               -font $gui_flags(font,codeentry) \
#               -width 30 \
#                -relief sunken \
#       ] -side top -fill x -expand yes
#       bind $w.templ.b.templ <Any-Return> "NewIndDef::remake_template_specification $w; ; [bind Text <Tab>]"
#       bind $w.templ.b.templ <Any-Tab> "NewIndDef::remake_template_specification $w; [bind Text <Tab>]"

        pack [frame $w.spec] -side top -fill both -expand yes -padx 5 -pady 5
        pack [label $w.spec.lab \
                -text "Full Specification:" \
                -font $gui_flags(font,labels) \
                -anchor w] -fill x
        pack [buttonbar $w.spec.bbar] -side top -fill x
        set definew [$w.spec.bbar addbutton button \
                -command "NewIndDef::define $w" \
                -text "Define"]

        set vals($w,selection) ""
        set helpcommand "Help::manual NewIndDef"
        $w.spec.bbar addbutton button \
                -command "NewIndDef::new_rule" \
                -text "New Rule"
        $w.spec.bbar addbutton sensitive button \
                -command "NewIndDef::delete_rule" \
                -sensitivevar vals($w,selection) \
                -sensitiveexpr "vals($w,selection) != {}" \
                -text "Delete Rule"
        $w.spec.bbar addbutton button \
                -command $helpcommand \
                -text "Help"
        $w.spec.bbar addbutton button \
                -command "destroy $w" \
                -text "Close"
        
        pack [richtextobjects $w.spec.spec \
                -selectioncommand "NewIndDef::new_rule_subset_selected $w" \
                -exportselection 0 \
                -expandbuttons 0 \
                -multiselect 0 \
                -mlbindbuttons 0] \
        ] -expand yes -fill both
        $w.spec.spec text config -height 6 -width 60
        
        bind $w <Destroy> "+NewIndDef::upon_destroy $w %W"

#       $w.templ.b.templ insert 0 "NewConst arg1 arg2"
#       NewIndDef::remake_template_specification $w
        if ![info exists NewIndDef_flags(previous)] {
            set NewIndDef_flags(previous) "NewConst arg1 arg2 = ..."
        }
        if [info exists initial] {
            set numrules [ML -type int "length (#rules (ScriptFragments.data_for_new_inductive_definition ($initial)))"]
            for {set i 1} {$i < $numrules} {incr i} {
                $w.spec.spec addobject [list RULE length "el $i (#rules (ScriptFragments.data_for_new_inductive_definition ($initial)))"]
            }
        } 


        $w.spec.spec expandall
        button_setDefault $definew
        update
        wm deiconify $w
        tkwait visibility $w
        update
        focus_goToFirst [$w.spec.bbar text]

        incr busy -1
        return $w
}


proc NewIndDef::upon_destroy { w realw } {
    if {$w==$realw} {
        unset_vals_for_widget $w
    }
}

#----------------------------------------------------------------------------
# NewIndDef::define
#
#----------------------------------------------------------------------------

proc NewIndDef::define { w  } {
        global gui_flags
        global NewIndDef_flags
        global TkHol_flags
        global feedback
        global busy
        global vals
        incr busy
        set spec [string trim [$w.spec.spec getpreterm]]
        set neat_spec [join [split $spec \n] "\n        "]
        if {![regexp  "^\[A-Za-z\]\[^\\(\\)\t \n\]*" $spec constname]} {
            errormessage $w.error "TkHol could not determine the name of the constant from the \
specification.  Only constants beginning with alphabet characters \
may be specified using this tool.  The name should also be the first \
word to appear in the specification."
            incr busy -1
            return 
        }
        set thm_name [set constname]_DEF
        set sections ""
        # Now proceed to the fixities, which are needed for HOL90 only.
            set defn "new_definition([ml_string $thm_name],[hol_term $neat_spec])"
            set script "[ml_val] $thm_name = $defn[ml_end_dec]"
            lappend sections [list $thm_name $defn $script]

        set total_script ""
        set thmspecs ""
        foreach section $sections {
            set name [lindex $section 0]
            set defn [lindex $section 1]
            set script [lindex $section 2]
            set feedback [list $w "Defining $name"]
            if [catch {ML_bind -check 1 -log 0 $name $defn} err] {
                errormessage $w.error $err; incr busy -1; return
            }
            lappend thmspecs [list $name [list THM [list CODE $name]]]
            ML -run 0 -toplevel 1 -log 1 $script
            set total_script "[set total_script]$script"
        }
                   
        if $TkHol_flags(managingScripts) {
            if {[choice $w.verify -text "\"$constname\" has been successfully defined.  Should $gui_flags(title) add this operation to [Scripts::current_script]?" -buttons [list Yes No]]=="Yes"} {
                Scripts::add_to_script $script
            }
        } else {
            set newwin [newwin TheoremsTopLevel \
                -title {NewIndDef Results} \
                -header {Theorem Generated by NewIndDef:} \
                -objspecs $thmspecs \
                -mlbindbuttons 0 \
                -expandbuttons 0 \
                -withtext 1 \
                -text $total_script]
            $newwin.objs expandall

        }
        set NewIndDef_flags(previous) $spec
        incr busy -1    

}



#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc tkntd { } {
   after 1 {
        source $NewIndDef_library/src/NewIndDef.tcl
        newwin NewIndDef
   }
}
