#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc cml { } {
    global tksml_slave_flags
    return $tksml_slave_flags(cml)
}

proc sml { } {
    global tksml_slave_flags
    return $tksml_slave_flags(sml)
}                                      


proc ml_prompt {  } { 
        global ml_prompt
        return $ml_prompt
}

proc ml_secondary_prompt {  } { 
        global ml_secondary_prompt
        return $ml_secondary_prompt
}

proc ml_initial_prompt {  } { 
        global tksml_slave_flags
        if [info exists tksml_slave_flags(initialprompt)] {
            return $tksml_slave_flags(initialprompt)
        }
        if [sml] { return "- " }
        if [cml] { return "#" }
}

proc ml_initial_secondary_prompt {  } { 
        global tksml_slave_flags
        if [sml] { return "= " }
        if [cml] { return "#" }
}


# The ml prompt as a regular expression. 
# Doesn't actually return the right result yet...

proc ml_re_prompt {  } {
        global ml_prompt
        if {$ml_prompt=="-"} { return {\-} } else { return $ml_prompt }
}


proc ml_list { l } { 
        return \[[join $l [ml_listsep]]\]
}

proc ml_stringlist { l } { 
        if [llength $l]==0 {
           return \[\]
        } else {
           return \[\"[join $l \"[ml_listsep]\"]\"\]
        }
}

proc ml_output { } { 
        if [cml] { return tty_write }
        if [sml] { return "(fn s => output(std_out,s))" }
}
proc ml_int_to_string { } { 
        if [cml] { return string_of_int }
        if [sml] { return "Integer.makestring" }
}
proc ml_eol { } { 
        if [cml] { return {\L} }
        if [sml] { return {\n} }
}

proc ml_file_ext {  } { 
        if [cml] { return ml }
        if [sml] { return sml }
}


proc ml_listsep {  } { 
        if [cml] { return ";" }
        if [sml] { return , }
}

proc ml_val {  } { 
        if [cml] { return let }
        if [sml] { return val }
}

proc ml_letval {  } { 
        if [cml] { return let }
        if [sml] { return {let val} }
}

proc ml_letin {  } { 
        return in
}

proc ml_letend {  } { 
        if [cml] { return {} }
        if [sml] { return end }
}

proc ml_fun {  } { 
        if [cml] { return letrec }
        if [sml] { return fun }
}
proc ml_lambda {  } { 
        if [cml] { return "\\" }
        if [sml] { return fn }
}
proc ml_dot {  } { 
        if [cml] { return . }
        if [sml] { return "=>" }
}

#----------------------------------------------------------
# Convert tcl strings to ml strings.  Have to convert
# escape patterns.  SML three digit escape patterns
# such as \123 within Tcl strings are not converted - this
# makes it slightly easier to specify SML escapes in Tcl
# code (and makes the conversion alot quicker - otherwise
# we would have to do a case analysis on each character.
# Mind you, this could be quick if we did it in C)
#
# ml_qstring can be used for cases where it is known that the
# string will not contain any quotes, backslashes or newlines.
#----------------------------------------------------------
proc ml_string { s } {
        if [cml] { return `$s` }
        if [sml] { 
           regsub -all {\\} $s {\\\\} s;
           regsub -all {\\([0-9][0-9][0-9])} $s {\1} s; 
           regsub -all \" $s \\\" s; 
           regsub -all \n $s "\\n" s; 
           return \"$s\"
        }
}
proc ml_qstring { s } {
        if [cml] { return `$s` }
        if [sml] { return "\"$s\"" }
}
proc ml_opt_paren { s } {
        if [regexp "\t| |\n" $s] { return "($s)" } else { return $s }
}
proc ml_bool { b } {
        if $b { return true } else { return false }
}
proc ml_frag_quote { s } {
        if [cml] { error "frag-quotes not supported in cml!" }
        if [sml] { return `$s` }
}
proc ml_dequote { t } { 
        if {[string range $t 0 0]=="`"} { set t [string range $t 1 end] }
        set len [string length $t]
        if {[string range $t [expr $len-1] [expr $len-1]]=="`"} { set t [string range $t 0 [expr $len-2]] }
        return $t       
}

proc ml_start_comment { } {
        if [cml] { return "%<" }
        if [sml] { return "(*" }
}

proc ml_end_comment { } {
        if [cml] { return ">%" }
        if [sml] { return "*)" }
}

proc ml_comment { c } {
        return "[ml_start_comment]$c[ml_end_comment]"
}

proc ml_end_dec { } {
        if [cml] { return ";;" }
        if [sml] { return ";" }
}

