#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




# File: init.tcl

# Description:
#       Initialization file for the Tk parametric framework.
#
#       This file is the initialization procedure for the Tk parametric
#       framework library.  It is invoked by
#
#c              source $dirName/init.tcl
#
#       where dirName is the directory in which the library resides.
#
#       It takes the following actions.
#
#       - The directory is added at the start of $auto_path.
#         (The name is obtained using `info script'.)
#
#       - Bindings are established for all widget classes to support keyboard
#         traversal and focusable buttons.
#
#       - <FocusIn> and <FocusOut> handlers are established for the
#         Toplevel window class, to implement the mixed focus model wherein
#         toplevel widgets are focus-follows-mouse but other widgets are
#         explicit-focus.
#         
#       - A binding for the <Destroy> event is established for all widgets,
#         in order to allow a hierarchy of widget destructors.  See
#         `widget:destroy' for a description of this procedure.

#set tkaux_library [file dirname [info script]]
#set auto_path [linsert $auto_path 0 $tkaux_library]


#
# Having this procedure forces the file to be sourced via autoloading
# when used as a Donald Syme-style--package.
#
# We also incorporate jtools' emacs-bindings here for text widgets.
proc tkaux::InitialisePackage { } {
        global tkaux_library
        j:tb:emacs_bind Text
        source $tkaux_library/src/error.tcl
}


        # BINDINGS:

        # Buttons

button_bindForTraversal Button

        # Canvases must be handled item-by-item, according to what the items do
        # with the keyboard focus.

        # Checkbuttons.

button_bindForTraversal Checkbutton

        # Entries.

entry_bindForTraversal Entry

        # Listboxes don't normally accept focus.  This should be changed.

        # Menus and Menubuttons are done reasonably competently by Tk

        # Radiobuttons

button_bindForTraversal Radiobutton

        # Scales

scale_bindForTraversal Scale

        # Scrollbars don't need keyboard traversal, particularly if
        # keyboard operations such as <PageUp> and <PageDown> are
        # made to work in listboxes

        # Texts

focus_bindForTraversal Text -controlonly
# focus_bindForTraversal Text

        # Turn on the focus management for toplevel windows

bind Toplevel <FocusIn> { toplevel_focusIn %W %d }
# a hack until Tk 4.0:
bind Tcl <FocusIn> { toplevel_focusIn %W %d }
bind TkTheoryViewer <FocusIn> { toplevel_focusIn %W %d }
bind TkTRS <FocusIn> { toplevel_focusIn %W %d }
bind TkGoalProof <FocusIn> { toplevel_focusIn %W %d }
bind SourceBrowser <FocusIn> { toplevel_focusIn %W %d }
bind . <FocusIn> { toplevel_focusIn %W %d }

        # Manage widget destruction for cleanup

bind all <Destroy> { widget:destroy %W }
bind all <Unmap> { widget:unmap %W }
widget_addBinding . Destroy { widget:destroyApp }
