#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





#############################################################################
#   TkHolShell.nw,v 1.2 1995/08/17 11:44:15 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#       Donald Syme
#       The Computer Laboratory
#       New Musuems Site
#       Pembroke St.
#       Cambridge U.K. CB2 3QG
#
#       email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################


#----------------------------------------------------------------------------
# WIDGET CLASS TkHolShell
#
# OPTIONS
#       "shell" options plus:
#
#       -withfedback
#
#       -title
#
#       -first
#
# COMMANDS
#
#       None.
#
#----------------------------------------------------------------------------

option add *TkHolShell.title TkHolShell widgetDefault
option add *TkHolShell.first 1 widgetDefault

proc TkHolShell {w args} {
        global TkHolShell_flags feedback
        global gui_flags

        set passon_args ""
        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i] -title {
                incr i
                set title [lindex $args $i]
            } -first {
                incr i
                set first [lindex $args $i]
            } default {
                lappend passon_args [lindex $args $i]
                incr i
                lappend passon_args [lindex $args $i]
            }
        }
        toplevel $w -class TkHolShell
        catch {wm withdraw $w}

        if ![info exists title] { set title [option get $w title Title] }
        if ![info exists first] { set first [option get $w first First] }

        if $first {
            set initialtext "
This  window  acts  just  like  a regular HOL shell interface.
You  may  use  up/down  arrow keys for history invocation, and
some  emacs-style  editing commands. To create extra shells to
access the same HOL session use \"Extra Shell\" button.

** NOTE: Instead of just <Return>, type <Control-Return> to execute **
** the ML code you type.                                            **

[ml_prompt]"
        } else {
            set initialtext [ml_prompt]
        }

        # 2. Do some windowing grunge
        #

        set feedback [list {} "Creating TkHolShell window..."]
        
        pack [frame $w.frame] -expand yes -fill both -side top

        wm minsize $w 1 1
        wm title $w $title

        scrollbar $w.scroll -relief sunken -command "$w.shell.text yview"
        eval [list shell $w.shell \
                -command "TkHolShell::execute $w" \
                -yscroll "$w.scroll set" \
                -prompt "" \
                -font $gui_flags(font,codeentry) \
                -initialtext $initialtext] $passon_args
        pack $w.scroll -in $w.frame -side right -fill y
        pack $w.shell -in $w.frame -side left -expand yes -fill both -padx 10

        pack [frame $w.controls] -side bottom

        pack [focusable button $w.controls.execute -text "Execute" \
                -command "shell::execute $w.shell" \
                -font $gui_flags(font,buttons) \
                -width 11] \
            -side left -padx 10 -pady 10        
        pack [focusable button $w.controls.extrashell -text "Extra Shell" \
                -command "newwin TkHolShell -height 18 -first 0"\
                -font $gui_flags(font,buttons) \
                -width 11] \
            -side left -padx 10 -pady 10        
        pack [focusable button $w.controls.close -text "Close" \
                -command "destroy $w" \
                -font $gui_flags(font,buttons) \
                -width 11] \
            -side left -padx 10 -pady 10        

        catch {wm deiconify $w}
        tkwait visibility $w
        update
        focus_goToFirst $w.shell
        button_setDefault $w.controls.execute
        
        return $w
}


proc TkHolShell::execute { w code } {
        
        # get the code and strip out all "return" characters.  Make them
        # into ML whitespace.  This prevents multiple "#" prompts
        # being printed in hol88 which confuses the TkHolSlave reader.
        # However, it may stuff up attempts to directly embed
        # \n's.
        #
        # This is no longer necessary since we are now using a
        # more recognisable prompt.
        # regsub -all "\n" $code " " new_code

        global busy
        incr busy
        global feedback
        set feedback [list $w "Executing ML code..."]

        if [catch {ML -check 1 -direct 1 -output_processor "TkHolShell::output $w" $code} err] {
            incr busy -1
            error "$err[hol_prompt]"
        }

        # Note... even an interrupted ML command should end up
        # back here...

        # Normaly shell expects the output from an execute command.
        # However we are manually processing the output.

        set feedback ""
        incr busy -1
        return ""       
}

proc TkHolShell::output { w text } {
        shell::output $w.shell $text
        update idletasks
}

#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc holshell { } {
   after 1 {
        source $TkHolShell_library/src/TkHolShell.tcl
        source $shell_library/src/shell.tcl
        newwin TkHolShell
   }
}



