#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




#----------------------------------------------------------------------------
# TheoremWidgets::ProcessArgs
#
#       -norichtext     turn rich text output off.  Automatically off
#                       for hol90.
#
#----------------------------------------------------------------------------

proc TheoremWidgets::ProcessArgs { argc argv } {
        global TheoremWidgets_flags

   if {[llength [info commands Preferences_Add]]==1} {

    Preferences_Add "Term, Type and Theorem Display" \
"Preferences related to the formatting of HOL terms may be \
specified here.  At present the list is overly complex - a simpler \
method of specifying font sizes and colors will be implemented \
some time soon. 

Interface maps produce special symbols and fonts such as those for set \
and arithmetic operations. Changing these values will \
only take effect if you save the options and restart TkHolWorkbench, \
or if you call the Tcl procedure
        TheoremWidgets::installInterfaceMap <interface map name> \$TheoremWidgets_flags(interface_map,<interface map name>)
from a Tcl window (see the \"Packages\" menu)." [list \
        [list TheoremWidgets_flags(pasteWithTypes) pasteWithTypes BOOL 0 "Paste With Types"  "If this is selected, types will be annotated when pasting selected term."] \
        [list TheoremWidgets_flags(show_restrictions) showRestrictions BOOL 1 "Show Restrictions"  "If this is true then restricted quantifications will be printed."] \
        [list TheoremWidgets_flags(show_assums) showAssums BOOL 1 "Show Assumptions"  "If this is true then assumptions to theorems will be printed."] \
        [list TheoremWidgets_flags(font,thmname) thmNameFont FONT "-Adobe-Helvetica-Medium-R-Normal-*-*-100-*" "Theorem Names - Font" "The font used to display the theorem name in the header to each theorem."] \
        [list TheoremWidgets_flags(font,thmkind) thmTypeFont FONT "-Adobe-Helvetica-Medium-O-Normal-*-*-100-*" "Theorem Type - Font" "The font used to display the theorem type in the header to each theorem."] \
        [list TheoremWidgets_flags(color,thmname) thmNameColor COLOR black "Theorem Names - Font" "The color used to display theorem name in the header to each theorem."] \
        [list TheoremWidgets_flags(color,thmkind) thmTypeColor COLOR black "Theorem Type - Font" "The color used to display the theorem type in the header to each theorem."] \
        [list TheoremWidgets_flags(mapsOnByDefault) interfaceMapping BOOL 1 "Use Interface Maps by Default" "Whether TkHolWorkbench should use interface maps by default."] \
        \
        [list TheoremWidgets_flags(interface_maps) interfaceMaps STRING [list BaseLogicTk SetsTk RealsTk] "TheoremWidgets Interface Maps" "The interface maps to use when displaying Richtext. These are specified below. "] \
        [list TheoremWidgets_flags(number_hyp) numberAssums BOOL 1 "Goals: Number Assumptions"  "If this is true then the assumptions list of goals will be numbered." ] \
        [list TheoremWidgets_flags(first_assum_on_top) firstAssumOnTop BOOL 1 "Goals: First assumption on top"  "This specifies whether the first assumption should be displayed at the top or the bottom of the assumption list."] \
      ]

    Preferences_Add "Interface Maps" \
"Install and alter interface maps.  A proper interface to create, modify and save interface maps will be developed in due course." \
      [list \
        [list TheoremWidgets_flags(interface_map,BaseLogicTk) BaseLogicTk INTERFACE_MAP [list \
            [list [list COMB CONST]     !               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  \"      \"]]] \
            [list [list COMB CONST]     ?               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  \$      \$]]] \
            [list [list COMB CONST]     ~               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  ~       ~]]] \
            [list [list COMB CONST]     /\\             [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\217}  "\x0d9"]]] \
            [list [list COMB CONST]     \\/             [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\218}  "\x0da"]]] \
            [list [list COMB CONST]     ==>             [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\222}  "\x0de"]]] \
            [list [list COMB CONST]     <==             [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\220}  "\x0dc"]]] \
            [list [list COMB CONST]     ->              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\174}  "\x0ae"]]] \
            [list [list COMB CONST]     >=              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\179}  "\x0b3"]]] \
            [list [list COMB CONST]     <=              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\163}  "\x0a3"]]] \
            [list [list COMB CONST]     *               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\180}  "\x0b4"]]] \
            [list [list ABS]            \\              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  l       l]]] \
            [list [list CONST VAR]      (               {}] \
            [list [list CONST VAR]      )               {}] \
            [list [list CONST VAR]      :               {}] \
            [list [list TYPE]           'a              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {a}     {a}]]] \
            [list [list TYPE]           'a1             [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {a1}    {a1}]]] \
            [list [list TYPE]           'a2             [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {a2}    {a2}]]] \
            [list [list TYPE]           'b              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {b}     {b}]]] \
            [list [list TYPE]           'c              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {c}     {c}]]] \
            [list [list TYPE]           'd              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {d}     {d}]]] \
            [list [list TYPE]           'e              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {e}     {e}]]] \
            [list [list TYPE]           'f              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {f}     {f}]]] \
            [list [list TYPE]           ->              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-0-1-0   {\174} "\x0ae"]]] \
            [list [list TYPE]           {}              Roman-Medium-I-Normal-tiny|*-*-*-*-Black-*-0-1-0] \
 \
            [list [list CONST]          {}              Roman-Medium-R-Normal-Normal|*-*-*-*-Black-*-0-0-0] \
            [list [list VAR]            {}              Roman-Medium-I-Normal-Normal|*-*-*-*-Blue-*-0-0-0] \
            [list [list default]        {}              Roman-Medium-R-Normal-Normal|*-*-*-*-Black-*-0-0-0] \
        ] \
        "BasicLogicTk Interface Map" \
"The interface map used for producing nifty looking symbols in Tk \
for the constructs in the HOL basic logic, and the arithmetic and lists \
libraries as well."] \
        \
        [list TheoremWidgets_flags(interface_map,SetsTk) SetsTk INTERFACE_MAP [list \
            [list [list COMB CONST]     IN              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\206}  "\x0ce"]]] \
            [list [list COMB CONST]     SUBSET          [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\205}  "\x0cd"]]] \
            [list [list COMB CONST]     PSUBSET         [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\204}  "\x0cc"]]] \
            [list [list COMB CONST]     INTER           [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\199}  "\x0c7"]]] \
            [list [list COMB CONST]     UNION           [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\200}  "\x0c8"]]] \
            [list [list CONST]          \{\}            [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  {\198}  "\x0c6"]]] \
            [list [list SET]            \\              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  |       |]]] \
            [list [list SET]            setlambda       [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  |       |]]] \
        ] \
        "SetsTk Interface Map" \
"The interface map used for producing nifty looking symbols in Tk \
for set theory constructs as found in the sets, finite_sets and \
pred_sets libraries."] \
        \
        [list TheoremWidgets_flags(interface_map,RealsTk) RealsTk INTERFACE_MAP [list \
            [list [list COMB CONST]     |<=|    [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  {\163}  "\x0a3"]]] \
            [list [list COMB CONST]     |<|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  <       <]]] \
            [list [list COMB CONST]     |>|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  >       >]]] \
            [list [list COMB CONST]     |>=|    [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  {\179}  "\x0b3"]]] \
            [list [list COMB CONST]     --      [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  -       -]]] \
            [list [list COMB CONST]     |-|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  -       -]]] \
            [list [list COMB CONST]     |+|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  +       +]]] \
            [list [list COMB CONST]     |*|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  {\180}  "\x0b4"]]] \
            [list [list COMB CONST]     /               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-0-0-0  {\184}  "\x0b8"]]] \
            [list [list COMB CONST]     &       [list [list Roman-Medium-R-Normal-Normal|*-*-*-*-Black-*-0-0-0  &       &]]] \
            [list [list CONST]          pi              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-0-0-0  p       p]]] \
        ] \
        "RealsTk Interface Map" \
"The interface map used for producing nifty looking symbols in Tk \
for real number constructs like those found in \
the reals library."] \
        \
      ]


   }

        set TheoremWidgets_flags(goal_line) ""
        set TheoremWidgets_flags(wrap_terms) 0

        for {set arg 0} {$arg < $argc} {incr arg} {
            if {[lindex $argv $arg]=="-norichtext"} {
                set TheoremWidgets_flags(richtext) 0
            }
        }
}


proc TheoremWidgets::InitialisePackage { } {
        global TheoremWidgets_flags
        global gui_flags
        set TheoremWidgets_flags(plaintext_loaded) 0
        set TheoremWidgets_flags(structuredtext_loaded) 0
        set TheoremWidgets_flags(notify_loaded) 0
        
        global install_dir_tkhol
            if [catch {ML -toplevel 1 "  \
                Globals.library_path := (!Globals.library_path)@\[[ml_string $install_dir_tkhol/hol90/mlpretty_runtime/]\];  \
                find_library [ml_string mlpretty_runtime];  \
                Globals.library_path := (!Globals.library_path)@\[[ml_string $install_dir_tkhol/hol90/termpaths/]\];  \
                find_library [ml_string termpaths];  \
                Globals.library_path := (!Globals.library_path)@\[[ml_string $install_dir_tkhol/hol90/richtext/]\];  \
                find_library [ml_string holpp_to_tcl];  \
                Globals.library_path := (!Globals.library_path)@\[[ml_string $install_dir_tkhol/hol90/plaintext/]\];  \
                find_library [ml_string plaintext]  \
            "}] {
                errormessage .error \
"One of the following library description files
        $install_dir_tkhol/hol90/mlpretty_runtime/mlpretty_runtime.hol_lib 
        $install_dir_tkhol/hol90/plaintext/plaintext.hol_lib 
        $install_dir_tkhol/hol90/richtext/holpp_to_tcl.hol_lib 
        $install_dir_tkhol/hol90/termpaths/termpaths.hol_lib 
could  not  be  found.  Perhaps  one  of the libraries has not
been   made   for   hol90.   Consult   your  $gui_flags(title)
installation  guide  and  remake  the  libraries.  If problems
persist, contact $gui_flags(maintainer)"
            }

        global RichText_flags
        if ![ML -type bool "op_mem lib_eq (find_library [ml_string holpp_to_tcl]) (loaded_libraries())"] {
            set RichText_flags(structuredtextOnByDefault) 0
        }
}
