#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





# fro autoloading ...
proc theoremsframe {} {}


composite_define TheoremsFrame {
        {-trace trace Trace "" composite_configPrivateNop}
} TheoremsFrame::initProc

proc TheoremsFrame::initProc { w args } {
        upvar #0 config$w config
        TheoremWidgets::delayedLoadNotify

        pack [richtextobjects $w.rto] -expand yes -fill both
        
        TheoremsFrame::register_trace $w $config(trace)

        widget_addBinding $w Destroy "TheoremsFrame::upon_destroy $w"

        return $w
}


composite_configFlag TheoremsFrame trace { w option value } {
        TheoremsFrame::deregister_trace $w
        TheoremsFrame::register_trace $w $value
        return private
}

composite_subcommand TheoremsFrame richtextobjects { w args } {
        if {[llength $args] > 0} {
            eval $w.rto $args
        } else {
            return $w.rto
        }
}


#----------------------------------------------------------------------------
#
# Register this tcl "object" as a notification client
# for this theory.  This means the tcl routines
# below will get called every time a theorem is saved
# via save_thm_and_notify.
#----------------------------------------------------------------------------

proc TheoremsFrame::register_trace { w trace } {
        global gui_flags
        upvar #0 $w data
        if $gui_flags(debug) { puts "In TheoremsFrame::register_trace, w = $w, trace = $trace" }
        if {$trace!=""} {
            set theory [lindex $trace 0]
            set type [lindex $trace 1]
            case $type th* {
                set data(trace_spec) on_new_thm
            } def* {
                set data(trace_spec) on_new_definition
            } ax* {
                set data(trace_spec) on_new_axiom
            } default {
                error "unexpected trace type $type"
            }
            ML -type void "TclTheoryNotification.add_client [ml_string $theory] \n(TclTheoryNotification.mk_client([ml_string TheoremsFrame],\n[ml_string $w],\[TclTheoryNotification.$data(trace_spec)\]))"
            set data(traced_theory) $theory
        }
        if $gui_flags(debug) { puts "Leaving TheoremsFrame::register_trace" }
}


#----------------------------------------------------------------------------
#
#
#----------------------------------------------------------------------------


proc TheoremsFrame::deregister_trace { w  } {   
        global gui_flags
        upvar #0 $w data
        if $gui_flags(debug) { puts "In TheoremsFrame::deregister_trace, w = $w" }
        if {[info exists data(traced_theory)] && [info exists data(trace_spec)]} {
            set theory $data(traced_theory)
            ML -type void "TclTheoryNotification.remove_client [ml_string $theory] \n(TclTheoryNotification.mk_client([ml_string TheoremsFrame],\n[ml_string $w],\[TclTheoryNotification.$data(trace_spec)\]))"
            unset data(trace_spec)
        }
        if $gui_flags(debug) { puts "Leaving TheoremsFrame::deregister_trace, w = $w" }
}


proc TheoremsFrame::upon_destroy { w } {
        TheoremsFrame::deregister_trace $w
}

#----------------------------------------------------------------------------
# TheoremsFrame::new_thm_Notify
#
# Called by ML when a theorem is saved via save_thm_and_notify and tracing
# for theorems is on.
#
#----------------------------------------------------------------------------

proc TheoremsFrame::new_thm_Notify { w theory thmname } {
        upvar #0 config$w config
        $w.rto addobjects [list $thmname [list THM [list $thmname theorem [lindex $config(trace) 0]]]]
}

proc TheoremsFrame::new_definition_Notify { w theory thmname } {
        upvar #0 config$w config
        $w.rto addobjects [list $thmname [list THM [list $thmname definition [lindex $config(trace) 0]]]]
}

proc TheoremsFrame::new_axiom_Notify { w theory thmname } {
        upvar #0 config$w config
        $w.rto addobjects [list $thmname [list THM [list $thmname axiom [lindex $config(trace) 0]]]]
}



